/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.sort.QuickSort;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.XPathException;

public final class DocumentOrderIterator
implements SequenceIterator,
Sortable {
    private SequenceIterator iterator;
    private SequenceExtent sequence;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private NodeInfo next = null;
    private int position = 0;

    public DocumentOrderIterator(SequenceIterator sequenceIterator, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.comparer = nodeOrderComparer;
        this.sequence = new SequenceExtent(sequenceIterator);
        if (this.sequence.getLength() > 1) {
            QuickSort.sort(this, 0, this.sequence.getLength() - 1);
        }
        this.iterator = this.sequence.iterate(null);
        this.advance();
    }

    private DocumentOrderIterator() {
    }

    public int compare(int n, int n2) {
        return this.comparer.compare((NodeInfo)this.sequence.itemAt(n), (NodeInfo)this.sequence.itemAt(n2));
    }

    public void swap(int n, int n2) {
        this.sequence.swap(n, n2);
    }

    private void advance() throws XPathException {
        while (this.iterator.hasNext()) {
            this.next = (NodeInfo)this.iterator.next();
            if (this.current != null && this.next.isSameNode(this.current)) continue;
            return;
        }
        this.next = null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        ++this.position;
        this.current = this.next;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        DocumentOrderIterator documentOrderIterator = new DocumentOrderIterator();
        documentOrderIterator.iterator = this.iterator.getAnother();
        documentOrderIterator.advance();
        return documentOrderIterator;
    }
}

