/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Comment;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Element;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Namespace;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.FunctionDefinition;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.TupleExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class QueryParser
extends ExpressionParser {
    private boolean preserveSpace = false;

    public final Expression parseQuery(String string, StaticQueryContext staticQueryContext) throws XPathException {
        this.env = staticQueryContext;
        this.numberOfRangeVariables = 0;
        this.t = new Tokenizer();
        this.t.tokenize(string);
        this.parseProlog();
        Expression expression = this.parseExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        this.setLocation(expression);
        staticQueryContext.bindUnboundFunctionCalls();
        staticQueryContext.fixupGlobalVariables();
        staticQueryContext.fixupGlobalFunctions();
        expression = expression.simplify();
        expression = expression.analyze(staticQueryContext);
        int n = ExpressionTool.allocateSlots(expression, 0);
        staticQueryContext.allocateLocalSlots(n);
        return expression;
    }

    private void parseProlog() throws XPathException {
        if (this.t.currentToken == 70) {
            this.parseQueryVersion();
            this.expect(90);
            this.nextToken();
        }
        while (true) {
            if (this.t.currentToken == 71) {
                this.parseNamespaceDeclaration();
            } else if (this.t.currentToken == 72) {
                this.nextToken();
                this.expect(101);
                if (this.t.currentTokenValue == "element") {
                    this.parseDefaultElementNamespace();
                } else if (this.t.currentTokenValue == "function") {
                    this.parseDefaultFunctionNamespace();
                } else if (this.t.currentTokenValue == "collation") {
                    this.parseDefaultCollation();
                } else {
                    this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                }
            } else if (this.t.currentToken == 75) {
                this.parseXmlSpaceDeclaration();
            } else if (this.t.currentToken == 74) {
                this.parseBaseURIDeclaration();
            } else if (this.t.currentToken == 76) {
                this.grumble("Saxon does not yet support schema import");
            } else if (this.t.currentToken == 77) {
                this.grumble("Saxon does not yet support multiple query modules");
            } else if (this.t.currentToken == 78) {
                this.parseVariableDeclaration();
            } else {
                if (this.t.currentToken != 79) break;
                this.parseFunctionDeclaration();
            }
            this.expect(90);
            this.nextToken();
        }
    }

    private void parseDefaultCollation() throws XPathException {
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).declareDefaultCollation(string);
        this.nextToken();
    }

    private void parseXmlSpaceDeclaration() throws XPathException {
        this.nextToken();
        this.nextToken();
        this.expect(101);
        if (this.t.currentTokenValue.equals("preserve")) {
            this.preserveSpace = true;
        } else if (this.t.currentTokenValue.equals("strip")) {
            this.preserveSpace = false;
        } else {
            this.grumble("xmlspace must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void parseBaseURIDeclaration() throws XPathException {
        this.nextToken();
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setBaseURI(string);
        this.nextToken();
    }

    private void parseDefaultFunctionNamespace() throws XPathException {
        this.nextToken();
        this.expect(101);
        if (!this.t.currentTokenValue.equals("namespace")) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultFunctionNamespace(string);
        this.nextToken();
    }

    private void parseDefaultElementNamespace() throws XPathException {
        this.nextToken();
        this.expect(101);
        if (!this.t.currentTokenValue.equals("namespace")) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultElementNamespace(string);
        this.nextToken();
    }

    private void parseNamespaceDeclaration() throws XPathException {
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Invalid namespace prefix '" + string + "'");
        }
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).declareNamespace(string, string2);
        this.nextToken();
    }

    private void parseQueryVersion() throws XPathException {
        this.nextToken();
        this.expect(102);
        if (!this.t.currentTokenValue.equals("1.0")) {
            this.grumble("XQuery version must be 1.0");
        }
        this.nextToken();
    }

    private void parseVariableDeclaration() throws XPathException {
        GlobalVariableDefinition globalVariableDefinition = new GlobalVariableDefinition();
        globalVariableDefinition.setLineNumber(this.t.getLineNumber());
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(101);
        globalVariableDefinition.setVariableName(this.t.currentTokenValue);
        int n = this.makeNameCode(this.t.currentTokenValue, false);
        globalVariableDefinition.setFingerprint(n & 0xFFFFF);
        this.nextToken();
        SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            sequenceType = this.parseSequenceType();
        }
        globalVariableDefinition.setRequiredType(sequenceType);
        if (this.t.currentToken == 53) {
            this.t.setState(0);
            this.nextToken();
            Expression expression = this.parseExpression();
            globalVariableDefinition.setIsParameter(false);
            globalVariableDefinition.setValueExpression(expression);
            this.expect(115);
            this.lookAhead();
        } else if (this.t.currentToken == 101) {
            if (this.t.currentTokenValue.equals("external")) {
                globalVariableDefinition.setIsParameter(true);
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        }
        this.nextToken();
        globalVariableDefinition.setRequiredType(sequenceType);
        ((StaticQueryContext)this.env).declareVariable(globalVariableDefinition);
    }

    private void parseFunctionDeclaration() throws XPathException {
        this.nextToken();
        this.expect(34);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            this.grumble("Saxon requires user-defined functions to have a namespace prefix");
        }
        FunctionDefinition functionDefinition = new FunctionDefinition();
        functionDefinition.displayName = this.t.currentTokenValue;
        functionDefinition.fingerprint = this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF;
        functionDefinition.arguments = new ArrayList();
        functionDefinition.resultType = SequenceType.ANY_SEQUENCE;
        functionDefinition.body = null;
        functionDefinition.lineNumber = this.t.getLineNumber();
        this.nextToken();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (this.t.currentToken != 104) {
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            int n = this.makeNameCode(string, false) & 0xFFFFF;
            Integer n2 = new Integer(n);
            if (hashSet.contains(n2)) {
                this.grumble("Duplicate parameter name " + this.t.currentTokenValue);
            }
            hashSet.add(n2);
            SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
            this.nextToken();
            if (this.t.currentToken == 101 && this.t.currentTokenValue.equals("as")) {
                this.nextToken();
                sequenceType = this.parseSequenceType();
            }
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(n);
            rangeVariableDeclaration.setRequiredType(sequenceType);
            rangeVariableDeclaration.setVariableName(string);
            functionDefinition.arguments.add(rangeVariableDeclaration);
            this.declareRangeVariable(rangeVariableDeclaration);
            if (this.t.currentToken == 104) break;
            if (this.t.currentToken == 7) {
                this.nextToken();
                continue;
            }
            this.grumble("Expected ',' or ')' after function argument, found '" + Tokenizer.tokens[this.t.currentToken] + "'");
        }
        this.t.setState(1);
        this.nextToken();
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            functionDefinition.resultType = this.parseSequenceType();
        }
        if (this.isKeyword("external")) {
            this.grumble("Saxon does not allow external functions to be declared");
        } else {
            this.expect(53);
            this.t.setState(0);
            this.nextToken();
            functionDefinition.body = this.parseExpression();
            this.expect(115);
            this.lookAhead();
        }
        int n = 0;
        while (n < functionDefinition.arguments.size()) {
            this.undeclareRangeVariable();
            ++n;
        }
        this.t.setState(0);
        this.nextToken();
        ((StaticQueryContext)this.env).declareFunction(functionDefinition);
    }

    protected Expression parseForExpression() throws XPathException {
        Object object;
        Object object2;
        Expression expression = null;
        ArrayList arrayList = new ArrayList();
        while (true) {
            if (this.t.currentToken == 111) {
                this.parseForClause(arrayList);
                continue;
            }
            if (this.t.currentToken != 116) break;
            this.parseLetClause(arrayList);
        }
        if (this.isKeyword("where")) {
            this.nextToken();
            expression = this.parseExpression();
        }
        if (this.isKeyword("stable")) {
            this.nextToken();
            if (!this.isKeyword("order")) {
                this.grumble("'stable' must be followed by 'order by'");
            }
        }
        List list = null;
        if (this.isKeyword("order")) {
            this.t.setState(1);
            this.nextToken();
            if (!this.isKeyword("by")) {
                this.grumble("'order' must be followed by 'by'");
            }
            this.t.setState(0);
            this.nextToken();
            list = this.parseSortDefinition();
        }
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Object object3 = this.parseExprSingle();
        if (expression != null) {
            object3 = new IfExpression(expression, (Expression)object3, EmptySequence.getInstance());
            this.setLocation((Expression)object3);
        }
        if (list != null) {
            TupleExpression tupleExpression = new TupleExpression(1 + list.size());
            this.setLocation(tupleExpression);
            tupleExpression.setExpression(0, (Expression)object3);
            int n = 0;
            while (n < list.size()) {
                object2 = new Atomizer(((SortSpec)list.get((int)n)).sortKey);
                this.setLocation((Expression)object2);
                tupleExpression.setExpression(n + 1, (Expression)object2);
                ++n;
            }
            object3 = tupleExpression;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            Object e = arrayList.get(n);
            if (e instanceof ExpressionParser.ForClause) {
                object2 = (ExpressionParser.ForClause)e;
                object = new ForExpression();
                ((Assignation)object).setVariableDeclaration(((ExpressionParser.ForClause)object2).rangeVariable);
                ((ForExpression)object).setPositionVariable(((ExpressionParser.ForClause)object2).positionVariable);
                ((ComputedExpression)object).setLineNumber((short)((ExpressionParser.ForClause)object2).lineNumber);
                ((Assignation)object).setSequence(((ExpressionParser.ForClause)object2).sequence);
                ((ForExpression)object).setAction((Expression)object3);
                object3 = object;
            } else {
                object2 = (LetClause)e;
                object = new LetExpression();
                ((Assignation)object).setVariableDeclaration(((LetClause)object2).variable);
                ((ComputedExpression)object).setLineNumber((short)((LetClause)object2).lineNumber);
                ((Assignation)object).setSequence(((LetClause)object2).value);
                ((Assignation)object).setAction((Expression)object3);
                object3 = object;
            }
            --n;
        }
        if (list != null) {
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[list.size()];
            int n2 = 0;
            while (n2 < list.size()) {
                object = (SortSpec)list.get(n2);
                FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
                fixedSortKeyDefinition.setSortKey(((SortSpec)list.get((int)n2)).sortKey);
                fixedSortKeyDefinition.setOrder(new StringValue(((SortSpec)object).ascending ? "ascending" : "descending"));
                fixedSortKeyDefinition.setEmptyFirst(((SortSpec)object).emptyFirst);
                if (((SortSpec)object).collation != null) {
                    fixedSortKeyDefinition.setCollation(this.env.getCollation(((SortSpec)object).collation));
                }
                fixedSortKeyDefinition.simplify();
                fixedSortKeyDefinitionArray[n2] = fixedSortKeyDefinition;
                ++n2;
            }
            object = new TupleSorter((Expression)object3, fixedSortKeyDefinitionArray);
            this.setLocation((Expression)object);
            object3 = object;
        }
        int n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            Object e = arrayList.get(n3);
            if (e instanceof ExpressionParser.ForClause && ((ExpressionParser.ForClause)e).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
            --n3;
        }
        return object3;
    }

    private void parseForClause(List list) throws XPathException {
        do {
            Object object;
            ExpressionParser.ForClause forClause = new ExpressionParser.ForClause();
            list.add(forClause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            rangeVariableDeclaration.setVariableName(string);
            forClause.rangeVariable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                object = this.parseSequenceType();
                rangeVariableDeclaration.setRequiredType((SequenceType)object);
                if (((SequenceType)object).getCardinality() != 512) {
                    this.grumble("Cardinality of range variable must be exactly one");
                }
            }
            forClause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(101);
                object = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object).setVariableFingerprint(this.makeNameCode(this.t.currentTokenValue, false) & 0xFFFFF);
                ((RangeVariableDeclaration)object).setRequiredType(new SequenceType(200, 88, 512));
                ((RangeVariableDeclaration)object).setVariableName(this.t.currentTokenValue);
                forClause.positionVariable = object;
                this.declareRangeVariable((VariableDeclaration)object);
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            forClause.sequence = this.parseExprSingle();
            this.declareRangeVariable(forClause.rangeVariable);
            if (forClause.positionVariable == null) continue;
            this.declareRangeVariable(forClause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    private void parseLetClause(List list) throws XPathException {
        do {
            LetClause letClause = new LetClause();
            letClause.lineNumber = this.t.getLineNumber();
            list.add(letClause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode(string, false) & 0xFFFFF);
            rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
            rangeVariableDeclaration.setVariableName(string);
            letClause.variable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                rangeVariableDeclaration.setRequiredType(this.parseSequenceType());
            }
            this.expect(52);
            this.nextToken();
            letClause.value = this.parseExprSingle();
            this.declareRangeVariable(rangeVariableDeclaration);
        } while (this.t.currentToken == 7);
    }

    private List parseSortDefinition() throws XPathException {
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>();
        while (true) {
            SortSpec sortSpec = new SortSpec();
            sortSpec.sortKey = this.parseExprSingle();
            sortSpec.ascending = true;
            sortSpec.emptyFirst = true;
            sortSpec.collation = null;
            this.t.setState(1);
            if (this.isKeyword("ascending")) {
                this.nextToken();
            } else if (this.isKeyword("descending")) {
                sortSpec.ascending = false;
                this.nextToken();
            }
            if (this.isKeyword("empty")) {
                this.nextToken();
                if (this.isKeyword("greatest")) {
                    sortSpec.emptyFirst = false;
                    this.nextToken();
                } else if (this.isKeyword("least")) {
                    sortSpec.emptyFirst = true;
                    this.nextToken();
                } else {
                    this.grumble("'empty' must be followed by 'greatest' or 'least'");
                }
            }
            if (this.isKeyword("collation")) {
                this.nextToken();
                this.expect(102);
                sortSpec.collation = this.t.currentTokenValue;
                this.nextToken();
            }
            arrayList.add(sortSpec);
            if (this.t.currentToken != 7) break;
            this.nextToken();
        }
        return arrayList;
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.nextToken();
        Expression expression = this.parseExpression();
        ArrayList<SequenceType> arrayList = new ArrayList<SequenceType>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this.expect(104);
        this.nextToken();
        LetExpression letExpression = new LetExpression();
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setVariableFingerprint(this.makeNameCode("typeswitchVar", false) & 0xFFFFF);
        rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
        rangeVariableDeclaration.setVariableName("typeswitchVar");
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(expression);
        while (this.t.currentToken == 59) {
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(101);
                object4 = this.t.currentTokenValue;
                this.nextToken();
                this.expect(101);
                if (!this.t.currentTokenValue.equals("as")) {
                    this.grumble("After 'case $" + (String)object4 + "', expected 'as'");
                }
                this.nextToken();
                object3 = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                object2 = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object2).setVariableFingerprint(this.makeNameCode((String)object4, false) & 0xFFFFF);
                ((RangeVariableDeclaration)object2).setRequiredType((SequenceType)object3);
                ((RangeVariableDeclaration)object2).setVariableName((String)object4);
                this.declareRangeVariable((VariableDeclaration)object2);
                object = this.parseExpression();
                this.undeclareRangeVariable();
                LetExpression letExpression2 = new LetExpression();
                letExpression2.setVariableDeclaration((RangeVariableDeclaration)object2);
                letExpression2.setSequence(new VariableReference(rangeVariableDeclaration));
                letExpression2.setAction((Expression)object);
                object = letExpression2;
            } else {
                object3 = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                object = this.parseExpression();
            }
            arrayList.add((SequenceType)object3);
            arrayList2.add(object);
        }
        if (arrayList.size() == 0) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(60);
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(101);
            object = this.t.currentTokenValue;
            this.nextToken();
            this.expect(25);
            this.nextToken();
            object4 = new RangeVariableDeclaration();
            ((RangeVariableDeclaration)object4).setVariableFingerprint(this.makeNameCode((String)object, false) & 0xFFFFF);
            ((RangeVariableDeclaration)object4).setRequiredType(SequenceType.ANY_SEQUENCE);
            ((RangeVariableDeclaration)object4).setVariableName((String)object);
            this.declareRangeVariable((VariableDeclaration)object4);
            object3 = this.parseExprSingle();
            this.undeclareRangeVariable();
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            object3 = this.parseExprSingle();
        }
        object = object3;
        int n = arrayList.size() - 1;
        while (n >= 0) {
            object = object2 = new IfExpression(new InstanceOfExpression(new VariableReference(rangeVariableDeclaration), (SequenceType)arrayList.get(n)), (Expression)arrayList2.get(n), (Expression)object);
            --n;
        }
        letExpression.setAction((Expression)object);
        return letExpression;
    }

    protected Expression parseConstructor() throws XPathException {
        int n = this.t.getLineNumber();
        switch (this.t.currentToken) {
            case 117: {
                Expression expression = this.parsePseudoXML(false);
                this.lookAhead();
                this.t.setState(2);
                this.nextToken();
                return expression;
            }
            case 54: {
                String string = this.t.currentTokenValue;
                if (string.equals("document")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    DocumentInstr documentInstr = new DocumentInstr(false, null, this.env.getBaseURI());
                    this.setLocation(documentInstr, n);
                    Instruction[] instructionArray = new Instruction[1];
                    Sequence sequence = new Sequence(expression, null);
                    instructionArray[0] = sequence;
                    this.setLocation(sequence, n);
                    documentInstr.setChildren(instructionArray);
                    return documentInstr;
                }
                if (string.equals("element")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression2 = null;
                    if (this.t.currentToken != 115) {
                        expression2 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    Element element = new Element(expression, null, ((StaticQueryContext)this.env).getNamespaceContext(), null, 94);
                    if (expression2 == null) {
                        element.setChildren(new Instruction[0]);
                    } else {
                        Instruction[] instructionArray = new Instruction[1];
                        Sequence sequence = new Sequence(expression2, null);
                        instructionArray[0] = sequence;
                        this.setLocation(sequence, n);
                        element.setChildren(instructionArray);
                    }
                    this.setLocation(element, n);
                    return element;
                }
                if (string.equals("attribute")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression3 = null;
                    if (this.t.currentToken != 115) {
                        expression3 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    Attribute attribute = new Attribute(expression, null, ((StaticQueryContext)this.env).getNamespaceContext(), 92, false);
                    if (expression3 == null) {
                        attribute.setValueExpression(StringValue.EMPTY_STRING);
                    } else {
                        attribute.setValueExpression(this.stringify(expression3));
                    }
                    this.setLocation(attribute, n);
                    return attribute;
                }
                if (string.equals("text")) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    ValueOf valueOf = new ValueOf(this.stringify(expression), false);
                    this.setLocation(valueOf, n);
                    return valueOf;
                }
                if (string.equals("comment")) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Comment comment = new Comment();
                    comment.setValueExpression(this.stringify(expression));
                    this.setLocation(comment, n);
                    return comment;
                }
                if (string.equals("pi")) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression4 = null;
                    if (this.t.currentToken != 115) {
                        expression4 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    ProcessingInstruction processingInstruction = new ProcessingInstruction(expression);
                    if (expression4 == null) {
                        processingInstruction.setValueExpression(StringValue.EMPTY_STRING);
                    } else {
                        processingInstruction.setValueExpression(this.stringify(expression4));
                    }
                    this.setLocation(processingInstruction, n);
                    return processingInstruction;
                }
                this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
            }
            case 55: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                Element element = new Element(stringValue, null, ((StaticQueryContext)this.env).getNamespaceContext(), null, 94);
                if (expression == null) {
                    element.setChildren(new Instruction[0]);
                } else {
                    Instruction[] instructionArray = new Instruction[1];
                    Sequence sequence = new Sequence(expression, null);
                    this.setLocation(sequence, n);
                    instructionArray[0] = sequence;
                    element.setChildren(instructionArray);
                }
                this.setLocation(element);
                return element;
            }
            case 56: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                Attribute attribute = new Attribute(stringValue, null, ((StaticQueryContext)this.env).getNamespaceContext(), 92, false);
                if (expression == null) {
                    attribute.setValueExpression(StringValue.EMPTY_STRING);
                } else {
                    attribute.setValueExpression(this.stringify(expression));
                }
                this.setLocation(attribute, n);
                return attribute;
            }
            case 57: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                ProcessingInstruction processingInstruction = new ProcessingInstruction(stringValue);
                if (expression == null) {
                    processingInstruction.setValueExpression(StringValue.EMPTY_STRING);
                } else {
                    processingInstruction.setValueExpression(this.stringify(expression));
                }
                this.setLocation(processingInstruction, n);
                return processingInstruction;
            }
        }
        return null;
    }

    private Expression parsePseudoXML(boolean bl) throws XPathException {
        Expression expression = null;
        int n = this.t.getLineNumber();
        char c = this.t.nextChar();
        switch (c) {
            case '!': {
                c = this.t.nextChar();
                if (c == '-') {
                    expression = this.parseCommentConstructor();
                    break;
                }
                if (c == '[') {
                    expression = this.parseCDATAConstructor();
                    break;
                }
                this.grumble("Expected '--' or '[CDATA[' after '<!'");
                break;
            }
            case '?': {
                expression = this.parsePIConstructor();
                break;
            }
            case '/': {
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((c = this.t.nextChar()) != '>') {
                        stringBuffer.append(c);
                    }
                    return new StringValue(stringBuffer);
                }
                this.grumble("Unmatched XML end tag");
                break;
            }
            default: {
                this.t.unreadChar();
                expression = this.parseDirectElementConstructor();
            }
        }
        this.setLocation(expression, n);
        return expression;
    }

    private Expression parseDirectElementConstructor() throws XPathException {
        Instruction[] instructionArray;
        Object object;
        Object object2;
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        if (!Name.isQName(string)) {
            this.grumble("Invalid element name '" + string + "'");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        while ((c = this.skipSpaces(c)) != '/' && c != '>') {
            stringBuffer.setLength(0);
            do {
                stringBuffer.append(c);
            } while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '=');
            object2 = stringBuffer.toString();
            if (!Name.isQName((String)object2)) {
                this.grumble("Invalid attribute name '" + (String)object2 + "'");
            }
            c = this.skipSpaces(c);
            this.expectChar(c, '=');
            c = this.t.nextChar();
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '=') break;
            char c2 = c = this.skipSpaces(c);
            if (c2 != '\"' && c2 != '\'') {
                this.grumble("Missing quotes around attribute value");
            }
            object = this.readAttributeValue(c2);
            c = this.t.nextChar();
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
                this.grumble("There must be whitespace after every attribute except the last");
            }
            if (((String)object2).equals("xmlns") || ((String)object2).startsWith("xmlns:")) {
                if (!(object instanceof StringValue)) {
                    this.grumble("Namespace URI must be a constant value");
                }
                if (((String)object2).equals("xmlns")) {
                    ((StaticQueryContext)this.env).declareNamespace("", ((StringValue)object).getStringValue());
                } else {
                    ((StaticQueryContext)this.env).declareNamespace(((String)object2).substring(6), ((StringValue)object).getStringValue());
                }
            }
            hashMap.put(object2, object);
        }
        object2 = ((StaticQueryContext)this.env).getNamespaceContext();
        Element element = new Element(new StringValue(string), null, (NamespaceContext)object2, null, 94);
        object = new ArrayList<SimpleNodeConstructor>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            SimpleNodeConstructor simpleNodeConstructor;
            instructionArray = (Instruction[])iterator.next();
            if (instructionArray.equals("xmlns")) {
                simpleNodeConstructor = new Namespace(new StringValue(""));
                simpleNodeConstructor.setValueExpression((Expression)hashMap.get(instructionArray));
                object.add(simpleNodeConstructor);
                continue;
            }
            if (instructionArray.startsWith("xmlns:")) {
                simpleNodeConstructor = new Namespace(new StringValue(instructionArray.substring(6)));
                simpleNodeConstructor.setValueExpression((Expression)hashMap.get(instructionArray));
                object.add(simpleNodeConstructor);
                continue;
            }
            simpleNodeConstructor = new Attribute(new StringValue((CharSequence)instructionArray), null, (NamespaceContext)object2, 0, false);
            simpleNodeConstructor.setValueExpression((Expression)hashMap.get(instructionArray));
            this.setLocation(simpleNodeConstructor);
            object.add(simpleNodeConstructor);
        }
        if (c == '/') {
            this.expectChar(this.t.nextChar(), '>');
        } else {
            this.readElementContent(string, (List)object);
        }
        instructionArray = new Instruction[object.size()];
        int n = 0;
        while (n < object.size()) {
            if (object.get(n) instanceof Instruction) {
                instructionArray[n] = (Instruction)object.get(n);
            } else {
                Sequence sequence = new Sequence((Expression)object.get(n), null);
                this.setLocation(sequence);
                instructionArray[n] = sequence;
            }
            ++n;
        }
        element.setChildren(instructionArray);
        this.setLocation(element);
        return element;
    }

    private void readElementContent(String string, List list) throws XPathException {
        try {
            while (true) {
                Expression expression;
                char c;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while ((c = this.t.nextChar()) != '<') {
                    if (c == '&') {
                        stringBuffer.append(this.readEntityReference());
                        bl = true;
                        continue;
                    }
                    if (c == '}') {
                        c = this.t.nextChar();
                        if (c != '}') {
                            this.grumble("'}' must be written as '}}' within element content");
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == '{') {
                        c = this.t.nextChar();
                        if (c != '{') {
                            c = '{';
                            break;
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() > 0 && bl | this.preserveSpace | !Navigator.isWhite(stringBuffer)) {
                    expression = new ValueOf(new StringValue(stringBuffer.toString()), false);
                    this.setLocation(expression);
                    list.add(expression);
                }
                if (c != '<') {
                    this.t.unreadChar();
                    this.t.setState(0);
                    this.lookAhead();
                    this.nextToken();
                    expression = this.parseExpression();
                    list.add(expression);
                    this.expect(115);
                    continue;
                }
                expression = this.parsePseudoXML(true);
                if (expression instanceof StringValue) {
                    String string2 = ((StringValue)expression).getStringValue().trim();
                    if (string2.equals(string)) {
                        return;
                    }
                    this.grumble("end tag '" + string2 + "' does not match start tag '" + string);
                    continue;
                }
                list.add(expression);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing end tag found for direct element constructor");
            return;
        }
    }

    private Expression parsePIConstructor() throws XPathException {
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            while (!stringBuffer.toString().endsWith("?>")) {
                char c = this.t.nextChar();
                if (n < 0 && " \t\r\n".indexOf(c) >= 0) {
                    n = stringBuffer.length();
                }
                stringBuffer.append(c);
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            String string2 = "";
            if (n < 0) {
                string = stringBuffer.toString();
            } else {
                string = stringBuffer.substring(0, n);
                string2 = stringBuffer.substring(n + 1).trim();
            }
            if (!XMLChar.isValidNCName(string)) {
                this.grumble("Invalid processing instruction name '" + string + "'");
            }
            ProcessingInstruction processingInstruction = new ProcessingInstruction(new StringValue(string));
            processingInstruction.setContent(string2);
            this.setLocation(processingInstruction);
            return processingInstruction;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private Expression parseCDATAConstructor() throws XPathException {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, 'C');
            c = this.t.nextChar();
            this.expectChar(c, 'D');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, 'T');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, '[');
            StringBuffer stringBuffer = new StringBuffer();
            while (!stringBuffer.toString().endsWith("]]>")) {
                stringBuffer.append(this.t.nextChar());
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 3);
            ValueOf valueOf = new ValueOf(new StringValue(string), false);
            this.setLocation(valueOf);
            return valueOf;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ']]>' found for CDATA section");
            return null;
        }
    }

    private Expression parseCommentConstructor() throws XPathException {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, '-');
            StringBuffer stringBuffer = new StringBuffer();
            while (!stringBuffer.toString().endsWith("--")) {
                stringBuffer.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 2);
            Comment comment = new Comment();
            comment.setContent(string);
            this.setLocation(comment);
            return comment;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    private Expression readAttributeValue(char c) throws XPathException {
        try {
            Expression[] expressionArray;
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            while (true) {
                char c2;
                StringBuffer stringBuffer = new StringBuffer();
                while ((c2 = this.t.nextChar()) != c) {
                    if (c2 == '<') {
                        this.grumble("'<' must be escaped within an attribute value");
                        continue;
                    }
                    if (c2 == '&') {
                        stringBuffer.append(this.readEntityReference());
                        continue;
                    }
                    if (c2 == '}') {
                        c2 = this.t.nextChar();
                        if (c2 != '}') {
                            this.grumble("'}' must be written as '}}' within an attribute value");
                        }
                        stringBuffer.append(c2);
                        continue;
                    }
                    if (c2 == '{') {
                        c2 = this.t.nextChar();
                        if (c2 != '{') {
                            this.t.unreadChar();
                            break;
                        }
                        stringBuffer.append(c2);
                        continue;
                    }
                    stringBuffer.append(c2);
                }
                if (stringBuffer.length() > 0) {
                    arrayList.add(new StringValue(stringBuffer));
                }
                if (c2 == c) break;
                this.lookAhead();
                this.nextToken();
                expressionArray = this.parseExpression();
                arrayList.add(this.stringify((Expression)expressionArray));
                this.expect(115);
            }
            int n = arrayList.size();
            if (n == 0) {
                return StringValue.EMPTY_STRING;
            }
            if (n == 1) {
                return ((Expression)arrayList.get(0)).simplify();
            }
            Concat concat = (Concat)SystemFunction.makeSystemFunction("concat");
            expressionArray = new Expression[n];
            expressionArray = arrayList.toArray(expressionArray);
            concat.setArguments(expressionArray);
            return concat.simplify();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing delimiter found for attribute constructor");
            return null;
        }
    }

    private Expression stringify(Expression expression) throws XPathException {
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, 101);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join");
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        return stringJoin;
    }

    protected StringValue makeStringLiteral(String string) throws XPathException {
        if (string.indexOf(38) == -1) {
            return new StringValue(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '&') {
                int n2 = string.indexOf(59, n);
                if (n2 < 0) {
                    this.grumble("No closing ';' found for entity or character reference");
                } else {
                    String string2 = string.substring(n + 1, n2);
                    stringBuffer.append(this.analyzeEntityReference(string2));
                    n = n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new StringValue(stringBuffer);
    }

    private String readEntityReference() throws XPathException {
        try {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            while ((c = this.t.nextChar()) != ';') {
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            return this.analyzeEntityReference(string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ';' found for entity or character reference");
            return null;
        }
    }

    private String analyzeEntityReference(String string) throws XPathException {
        if (string.equals("lt")) {
            return "<";
        }
        if (string.equals("gt")) {
            return ">";
        }
        if (string.equals("amp")) {
            return "&";
        }
        if (string.equals("quot")) {
            return "\"";
        }
        if (string.equals("apos")) {
            return "'";
        }
        if (string.length() < 2 || string.charAt(0) != '#') {
            this.grumble("invalid entity reference &" + string + ";");
            return null;
        }
        string = string.toLowerCase();
        return this.parseCharacterReference(string);
    }

    private String parseCharacterReference(String string) throws XPathException {
        int n = 0;
        if (string.charAt(1) == 'x') {
            int n2 = 2;
            while (n2 < string.length()) {
                int n3 = "0123456789abcdef".indexOf(string.charAt(n2));
                if (n3 < 0) {
                    this.grumble("invalid character '" + string.charAt(n2) + "' in hex character reference");
                }
                n = n * 16 + n3;
                ++n2;
            }
        } else {
            int n4 = 1;
            while (n4 < string.length()) {
                int n5 = "0123456789".indexOf(string.charAt(n4));
                if (n5 < 0) {
                    this.grumble("invalid character '" + string.charAt(n4) + "' in decimal character reference");
                }
                n = n * 10 + n5;
                ++n4;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.grumble("Invalid XML character reference x" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            return "" + (char)n;
        }
        if (n <= 0x10FFFF) {
            return "" + (char)(0xD800 | (n -= 65536) >> 10) + (char)(0xDC00 | n & 0x3FF);
        }
        this.grumble("Character reference x" + Integer.toHexString(n) + " is too large");
        return null;
    }

    private void lookAhead() throws XPathException {
        try {
            this.t.lookAhead();
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private char skipSpaces(char c) {
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.t.nextChar();
        }
        return c;
    }

    private void expectChar(char c, char c2) throws XPathException {
        if (c != c2) {
            this.grumble("Expected '" + c2 + "', found '" + c + "'");
        }
    }

    protected String getLanguage() {
        return "XQuery";
    }

    private static class SortSpec {
        public Expression sortKey;
        public boolean ascending;
        public boolean emptyFirst;
        public String collation;

        private SortSpec() {
        }
    }

    private static class LetClause {
        public RangeVariableDeclaration variable;
        public Expression value;
        public int lineNumber;

        private LetClause() {
        }
    }
}

