/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Orphan
implements NodeInfo {
    private short kind;
    private int nameCode = -1;
    private CharSequence stringValue;
    private int typeAnnotation = 0;
    private NamePool namePool;
    private String systemId;

    public Orphan(NamePool namePool) {
        this.namePool = namePool;
    }

    public void setNodeKind(short s) {
        this.kind = s;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public void setStringValue(CharSequence charSequence) {
        this.stringValue = charSequence;
    }

    public void setTypeAnnotation(int n) {
        this.typeAnnotation = n;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public int getItemType() {
        return this.kind;
    }

    public Value getTypedValue() {
        if (this.typeAnnotation == 0) {
            return new UntypedAtomicValue(this.stringValue);
        }
        try {
            return new StringValue(this.stringValue).convert(this.typeAnnotation);
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException("Value does not match type annotation: " + xPathException);
        }
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        return this.systemId;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this.isSameNode(nodeInfo)) {
            return 0;
        }
        return this.hashCode() < nodeInfo.hashCode() ? -1 : 1;
    }

    public String getStringValue() {
        return this.stringValue.toString();
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalName() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getLocalName(this.nameCode);
    }

    public String getURI() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getURI(this.nameCode);
    }

    public String getDisplayName() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.namePool.getDisplayName(this.nameCode);
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                return new SingletonIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                if (nodeTest.matches(this.kind, this.getFingerprint(), this.getTypeAnnotation())) {
                    return new SingletonIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(String string, String string2) {
        return null;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String generateId() {
        return "Q" + this.hashCode();
    }

    public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        Navigator.copy(this, receiver, this.namePool, n, bl);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) {
    }
}

