/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceChecker;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class Sequence
extends ExprInstruction {
    private Expression select;
    private SequenceType requiredType;

    public Sequence(Expression expression, SequenceType sequenceType) {
        this.select = expression;
        this.requiredType = sequenceType;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression simplify() throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify();
        }
        return super.simplify();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.analyze(staticContext);
            if (this.requiredType != null) {
                RoleLocator roleLocator = new RoleLocator(4, "sequence/select", 0);
                this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, roleLocator);
            }
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
                ++n;
            }
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        if (this.select != null) {
            list.add(this.select);
            return;
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ((ExprInstruction)this.children[n]).getXPathExpressions(list);
                ++n;
            }
        }
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof ExprInstruction) {
                    Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                    this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++n;
            }
        }
    }

    public String getInstructionName() {
        return "xsl:sequence";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        if (this.select != null) {
            SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
            while (sequenceIterator.hasNext()) {
                sequenceReceiver.append(sequenceIterator.next());
            }
            return null;
        }
        if (this.requiredType == null) {
            TailCall tailCall = null;
            if (this.children != null) {
                tailCall = this.processChildrenLeavingTail(xPathContext);
            }
            return tailCall;
        }
        SequenceChecker sequenceChecker = new SequenceChecker();
        sequenceChecker.setRequiredType(this.requiredType);
        sequenceChecker.setUnderlyingReceiver(sequenceReceiver);
        controller.setReceiver(sequenceChecker);
        if (this.select != null) {
            SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
            while (sequenceIterator.hasNext()) {
                sequenceChecker.append(sequenceIterator.next());
            }
        }
        if (this.children != null) {
            this.processChildren(xPathContext);
        }
        sequenceChecker.finalCheck();
        controller.resetOutputDestination(sequenceReceiver);
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.children != null) {
            throw new IllegalStateException("Cannot process xsl:sequence with children as an expression");
        }
        return this.select.iterate(xPathContext);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "sequence");
        if (this.select != null) {
            this.select.display(n + 1);
        }
        if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

