/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.xpath.XPathException;

public final class NamespaceContext
implements Serializable {
    private int[] namespaceCodes;

    public NamespaceContext(int[] nArray) {
        this.namespaceCodes = nArray;
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    public String getURIForPrefix(String string, boolean bl, NamePool namePool) {
        if (string.equals("") && !bl) {
            return "";
        }
        int n = this.namespaceCodes.length - 1;
        while (n >= 0) {
            try {
                if (namePool.getPrefixFromNamespaceCode(this.namespaceCodes[n]).equals(string)) {
                    return namePool.getURIFromNamespaceCode(this.namespaceCodes[n]);
                }
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("Crash! i=" + n + ", prefix=" + string + ";");
                System.err.println("namespacecodes[i] = " + this.namespaceCodes[n]);
                System.err.println("pool = " + namePool);
                namePool.diagnosticDump();
            }
            --n;
        }
        if (string.equals("") && bl) {
            return "";
        }
        return null;
    }

    public int getFingerprint(String string, boolean bl, NamePool namePool) throws XPathException {
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Dynamic(qNameException.getMessage());
        }
        String string2 = this.getURIForPrefix(stringArray[0], bl, namePool);
        if (string2 == null) {
            throw new XPathException.Dynamic("Namespace prefix " + stringArray[0] + " has not been declared");
        }
        return namePool.getFingerprint(string2, stringArray[1]);
    }
}

