/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.ParameterSet;
import net.sf.saxon.instruct.DefiningVariable;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class Bindery {
    private Object[] globals;
    private boolean[] busy;
    private Object[][] stack = new Object[20][];
    private Object[] currentStackFrame;
    private ParameterSet globalParameters;
    private int top = -1;
    private int allocated = 0;
    private int localSpace = 0;

    public void allocateGlobals(int n) {
        this.globals = new Object[n];
        this.busy = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.globals[n2] = null;
            this.busy[n2] = false;
            ++n2;
        }
    }

    public void defineGlobalParameters(ParameterSet parameterSet) {
        this.globalParameters = parameterSet;
    }

    public boolean useGlobalParameter(int n, DefiningVariable definingVariable) throws XPathException {
        if (this.globalParameters == null) {
            return false;
        }
        Value value = this.globalParameters.get(n);
        if (value == null) {
            return false;
        }
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).convert(definingVariable.getRequiredType().getPrimaryType());
        } else {
            int n2 = definingVariable.getRequiredType().getPrimaryType();
            if (!Type.isSubType(value.getItemType(), n2)) {
                throw new XPathException.Type("Global parameter requires type " + Type.getTypeName(n2) + "; supplied value has type " + Type.getTypeName(value.getItemType()));
            }
            int n3 = definingVariable.getRequiredType().getCardinality();
            if (!Cardinality.subsumes(n3, value.getCardinality())) {
                throw new XPathException.Type("Supplied value of external parameter does not match the required cardinality");
            }
        }
        this.globals[definingVariable.getSlotNumber()] = value;
        return true;
    }

    public void defineGlobalVariable(DefiningVariable definingVariable, Value value) {
        this.globals[definingVariable.getSlotNumber()] = value;
    }

    public void setExecuting(DefiningVariable definingVariable, boolean bl) throws XPathException {
        int n = definingVariable.getSlotNumber();
        if (bl) {
            if (this.busy[n]) {
                throw new XPathException.Dynamic("Circular definition");
            }
            this.busy[n] = true;
        } else {
            this.busy[n] = false;
        }
    }

    public boolean isEvaluated(DefiningVariable definingVariable) {
        return this.globals[definingVariable.getSlotNumber()] != null;
    }

    public void allocateLocals(int n) {
        if (n > this.localSpace) {
            this.localSpace = n;
        }
    }

    public void openStackFrame(ParameterSet parameterSet) {
        this.allocateStackFrame();
        this.currentStackFrame[0] = parameterSet;
    }

    public void openStackFrame() {
        this.allocateStackFrame();
    }

    public void openStackFrame(Value[] valueArray) {
        this.allocateStackFrame();
        System.arraycopy(valueArray, 0, this.currentStackFrame, 1, valueArray.length);
    }

    private void allocateStackFrame() {
        if (++this.top >= this.allocated) {
            if (this.allocated == this.stack.length) {
                Object[][] objectArrayArray = new Object[this.allocated * 2][];
                System.arraycopy(this.stack, 0, objectArrayArray, 0, this.allocated);
                this.stack = objectArrayArray;
            }
            this.currentStackFrame = new Object[this.localSpace + 1];
            this.stack[this.top] = this.currentStackFrame;
            ++this.allocated;
        } else {
            this.currentStackFrame = this.stack[this.top];
        }
        int n = 0;
        while (n < this.currentStackFrame.length) {
            this.currentStackFrame[n] = null;
            ++n;
        }
    }

    public void closeStackFrame() {
        --this.top;
        this.currentStackFrame = this.top < 0 ? null : this.stack[this.top];
    }

    public boolean useLocalParameter(int n, DefiningVariable definingVariable) throws XPathException {
        ParameterSet parameterSet = (ParameterSet)this.currentStackFrame[0];
        if (parameterSet == null) {
            return false;
        }
        Value value = parameterSet.get(n);
        if (value == null) {
            this.currentStackFrame[definingVariable.getSlotNumber() + 1] = null;
            return false;
        }
        this.currentStackFrame[definingVariable.getSlotNumber() + 1] = value;
        return true;
    }

    public void setLocalVariable(int n, Value value) {
        if (this.currentStackFrame == null) {
            throw new IllegalArgumentException("Can't define local variable: stack is empty");
        }
        this.currentStackFrame[n + 1] = value;
    }

    public Value evaluateGlobalVariable(DefiningVariable definingVariable) {
        return (Value)this.globals[definingVariable.getSlotNumber()];
    }

    public Object[] getCurrentStackFrame() {
        return this.currentStackFrame;
    }

    public void openCopiedStackFrame(Object[] objectArray) {
        this.allocateStackFrame();
        System.arraycopy(objectArray, 0, this.currentStackFrame, 0, objectArray.length);
    }

    public Value getValue(DefiningVariable definingVariable, int n) {
        if (definingVariable.isGlobal()) {
            return (Value)this.globals[definingVariable.getSlotNumber()];
        }
        Object[] objectArray = this.stack[n];
        if (objectArray != null) {
            return (Value)objectArray[definingVariable.getSlotNumber() + 1];
        }
        return null;
    }

    public int getFrameId() {
        return this.top;
    }

    public void assignVariable(DefiningVariable definingVariable, Value value) {
        if (definingVariable.isGlobal()) {
            this.defineGlobalVariable(definingVariable, value);
        } else {
            this.setLocalVariable(definingVariable.getSlotNumber(), value);
        }
    }
}

