/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.value.SequenceType;

public class ApplyImports
extends Instruction {
    private WithParam[] actualParams = null;

    public ApplyImports(WithParam[] withParamArray) {
        this.actualParams = withParamArray;
    }

    public String getInstructionName() {
        return "xsl:apply-imports";
    }

    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Template template;
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = null;
        if (this.actualParams != null) {
            parameterSet = new ParameterSet();
            int n = 0;
            while (n < this.actualParams.length) {
                parameterSet.put(this.actualParams[n].getVariableFingerprint(), this.actualParams[n].getSelectValue(xPathContext));
                ++n;
            }
        }
        if ((template = xPathContext.getController().getCurrentTemplate()) == null) {
            throw new TransformerException("There is no current template rule");
        }
        int n = template.getMinImportPrecedence();
        int n2 = template.getPrecedence() - 1;
        controller.applyImports(n, n2, parameterSet);
        return null;
    }
}

