/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class StringLength
extends SystemFunction {
    private boolean shortcut = false;

    public Expression simplify() throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments(true);
    }

    public void setShortcut() {
        this.shortcut = true;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        String string = stringValue.getStringValue();
        if (this.shortcut) {
            return new IntegerValue(string.length() > 0 ? 1 : 0);
        }
        return new IntegerValue(StringValue.getLength(string));
    }
}

