/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class StringJoin
extends SystemFunction {
    public Expression analyze(StaticContext staticContext) throws XPathException {
        Expression expression = super.analyze(staticContext);
        if (expression instanceof StringJoin) {
            return ((StringJoin)expression).simplifySingleton();
        }
        return expression;
    }

    private Expression simplifySingleton() {
        if (!Cardinality.allowsMany(this.argument[0].getCardinality())) {
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        StringBuffer stringBuffer = new StringBuffer();
        if (sequenceIterator.hasNext()) {
            stringBuffer.append(sequenceIterator.next().getStringValue());
        }
        if (sequenceIterator.hasNext()) {
            String string = this.argument[1].evaluateItem(xPathContext).getStringValue();
            do {
                stringBuffer.append(string);
                stringBuffer.append(sequenceIterator.next().getStringValue());
            } while (sequenceIterator.hasNext());
        }
        return new StringValue(stringBuffer);
    }
}

