/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Replace
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify() throws XPathException {
        Expression expression = this.simplifyArguments(true);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 3);
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        StringValue stringValue2 = (StringValue)this.argument[2].evaluateItem(xPathContext);
        if (stringValue2 == null) {
            return null;
        }
        String string = stringValue2.getStringValue();
        this.checkReplacement(string);
        Pattern pattern = this.regexp;
        if (pattern == null) {
            String string2;
            object = (StringValue)this.argument[1].evaluateItem(xPathContext);
            if (object == null) {
                return null;
            }
            if (this.getNumberOfArguments() == 3) {
                string2 = "";
            } else {
                StringValue stringValue3 = (StringValue)this.argument[3].evaluateItem(xPathContext);
                if (stringValue3 == null) {
                    return null;
                }
                string2 = stringValue3.getStringValue();
            }
            try {
                pattern = Pattern.compile(((StringValue)object).getStringValue(), Matches.setFlags(string2));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        object = pattern.matcher(stringValue.getStringValue()).replaceAll(stringValue2.getStringValue());
        return new StringValue((CharSequence)object);
    }

    private void checkReplacement(String string) throws XPathException {
        int n = 0;
        while (n < string.length()) {
            char c;
            char c2 = string.charAt(n);
            if (c2 == '$') {
                if (n + 1 < string.length()) {
                    if ((c = string.charAt(++n)) < '1' || c > '9') {
                        this.dynamicError("Invalid replacement string in replace(): $ sign must be followed by digit 1-9");
                    }
                } else {
                    this.dynamicError("Invalid replacement string in replace(): $ sign at end of string");
                }
            } else if (c2 == '\\') {
                if (n + 1 < string.length()) {
                    if ((c = string.charAt(++n)) != '\\' && c != '$') {
                        this.dynamicError("Invalid replacement string in replace(): \\ character must be followed by \\ or $");
                    }
                } else {
                    this.dynamicError("Invalid replacement string in replace(): \\ character at end of string");
                }
            }
            ++n;
        }
    }
}

