/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public class Remove
extends SystemFunction {
    public int getItemType() {
        return this.argument[0].getItemType();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        IntegerValue integerValue = (IntegerValue)this.argument[1].evaluateItem(xPathContext);
        return new RemoveIterator(sequenceIterator, (int)integerValue.getValue());
    }

    private class RemoveIterator
    implements SequenceIterator {
        SequenceIterator base;
        int removePosition;
        int position = 0;
        Item nextItem = null;
        Item current = null;

        public RemoveIterator(SequenceIterator sequenceIterator, int n) throws XPathException {
            this.base = sequenceIterator;
            this.removePosition = n;
            this.advance();
        }

        private void advance() throws XPathException {
            if (this.base.hasNext()) {
                this.nextItem = this.base.next();
                if (this.base.position() == this.removePosition) {
                    this.advance();
                }
            } else {
                this.nextItem = null;
            }
        }

        public boolean hasNext() {
            return this.nextItem != null;
        }

        public Item next() throws XPathException {
            this.current = this.nextItem;
            ++this.position;
            this.advance();
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RemoveIterator(this.base.getAnother(), this.removePosition);
        }
    }
}

