/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Serializable serializable = this.getAtomicComparer(1, xPathContext);
        if (this.operation == 3) {
            serializable = new DescendingComparer((Comparator)((Object)serializable));
        }
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = null;
        if (sequenceIterator.hasNext()) {
            atomicValue = (AtomicValue)sequenceIterator.next();
        }
        while (sequenceIterator.hasNext()) {
            AtomicValue atomicValue2 = (AtomicValue)sequenceIterator.next();
            try {
                if (serializable.compare(atomicValue2, atomicValue) >= 0) continue;
                atomicValue = atomicValue2;
            }
            catch (ClassCastException classCastException) {
                this.typeError("Cannot compare " + Type.getTypeName(atomicValue.getItemType()) + " with " + Type.getTypeName(atomicValue2.getItemType()));
                return null;
            }
        }
        return atomicValue;
    }
}

