/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Matches
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify() throws XPathException {
        Expression expression = this.simplifyArguments(true);
        if (!(expression instanceof Value)) {
            this.regexp = Matches.tryToCompile(this.argument, 1, 2);
        }
        return expression;
    }

    public static int setFlags(String string) throws XPathException {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case 'm': {
                    n |= 8;
                    break;
                }
                case 'i': {
                    n |= 2;
                    break;
                }
                default: {
                    throw new XPathException.Dynamic("Invalid character '" + c + "' in regular expression flags");
                }
            }
            ++n2;
        }
        if ((n & 8) == 0) {
            n |= 0x20;
        }
        return n;
    }

    protected static Pattern tryToCompile(Expression[] expressionArray, int n, int n2) throws XPathException {
        if (n > expressionArray.length - 1) {
            return null;
        }
        String string = null;
        if (expressionArray.length - 1 < n2) {
            string = "";
        } else if (expressionArray[n2] instanceof StringValue) {
            string = ((StringValue)expressionArray[n2]).getStringValue();
        }
        if (expressionArray[n] instanceof StringValue && string != null) {
            int n3 = Matches.setFlags(string);
            try {
                return Pattern.compile(((StringValue)expressionArray[n]).getStringValue(), n3);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        Pattern pattern = this.regexp;
        if (pattern == null) {
            String string;
            StringValue stringValue2 = (StringValue)this.argument[1].evaluateItem(xPathContext);
            if (stringValue2 == null) {
                return null;
            }
            if (this.getNumberOfArguments() == 2) {
                string = "";
            } else {
                StringValue stringValue3 = (StringValue)this.argument[2].evaluateItem(xPathContext);
                if (stringValue3 == null) {
                    return null;
                }
                string = stringValue3.getStringValue();
            }
            try {
                pattern = Pattern.compile(stringValue2.getStringValue(), Matches.setFlags(string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new XPathException.Dynamic(patternSyntaxException);
            }
        }
        return BooleanValue.get(pattern.matcher(stringValue.getStringValue()).find());
    }
}

