/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Compare
extends CollatingFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        StringValue stringValue2 = (StringValue)this.argument[1].evaluateItem(xPathContext);
        if (stringValue2 == null) {
            return null;
        }
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        int n = atomicComparer.compare(stringValue, stringValue2);
        if (n < 0) {
            return IntegerValue.MINUS_ONE;
        }
        if (n > 0) {
            return IntegerValue.PLUS_ONE;
        }
        return IntegerValue.ZERO;
    }
}

