/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public class Aggregate
extends SystemFunction {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.argument[0] = ExpressionTool.unsorted(this.argument[0], true);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        switch (this.operation) {
            case 4: {
                return new IntegerValue(this.getCount(xPathContext));
            }
            case 0: {
                return this.total(this.argument[0].iterate(xPathContext));
            }
            case 1: {
                return this.average(this.argument[0].iterate(xPathContext));
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    private NumericValue total(SequenceIterator sequenceIterator) throws XPathException {
        if (!sequenceIterator.hasNext()) {
            return new DoubleValue(0.0);
        }
        NumericValue numericValue = (NumericValue)sequenceIterator.next();
        while (sequenceIterator.hasNext()) {
            NumericValue numericValue2 = (NumericValue)sequenceIterator.next();
            numericValue = numericValue.arithmetic(15, numericValue2);
        }
        return numericValue;
    }

    private NumericValue average(SequenceIterator sequenceIterator) throws XPathException {
        if (!sequenceIterator.hasNext()) {
            return null;
        }
        int n = 1;
        NumericValue numericValue = (NumericValue)sequenceIterator.next();
        while (sequenceIterator.hasNext()) {
            NumericValue numericValue2 = (NumericValue)sequenceIterator.next();
            numericValue = numericValue.arithmetic(15, numericValue2);
            ++n;
        }
        return numericValue.arithmetic(18, new IntegerValue(n));
    }

    private int getCount(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        int n = 0;
        while (sequenceIterator.hasNext()) {
            sequenceIterator.next();
            ++n;
        }
        return n;
    }
}

