/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class RangeExpression
extends BinaryExpression {
    private static SequenceType INT_TYPE = new SequenceType(200, 88, 768);

    public RangeExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        RoleLocator roleLocator = new RoleLocator(1, "to", 0);
        this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], INT_TYPE, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, "to", 1);
        this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], INT_TYPE, false, roleLocator2);
        return super.simplify();
    }

    public int getItemType() {
        return 200;
    }

    public int computeCardinality() {
        return 1536;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        IntegerValue integerValue = (IntegerValue)this.operands[0].evaluateItem(xPathContext);
        if (integerValue == null) {
            return new EmptyIterator();
        }
        IntegerValue integerValue2 = (IntegerValue)this.operands[1].evaluateItem(xPathContext);
        if (integerValue2 == null) {
            return new EmptyIterator();
        }
        return new RangeIterator(integerValue.getValue(), integerValue2.getValue());
    }

    private static class RangeIterator
    implements SequenceIterator {
        long start;
        long currentValue;
        int increment;
        long limit;

        public RangeIterator(long l, long l2) throws XPathException {
            this.start = l;
            this.increment = l <= l2 ? 1 : -1;
            this.currentValue = l;
            this.limit = l2;
        }

        public boolean hasNext() {
            if (this.increment > 0) {
                return this.currentValue <= this.limit;
            }
            return this.currentValue >= this.limit;
        }

        public Item next() throws XPathException {
            long l = this.currentValue;
            this.currentValue += (long)this.increment;
            return new IntegerValue(l);
        }

        public Item current() {
            return new IntegerValue(this.currentValue - (long)this.increment);
        }

        public int position() {
            if (this.increment > 0) {
                return (int)(this.currentValue - this.start);
            }
            return (int)(this.start - this.currentValue);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RangeIterator(this.start, this.limit);
        }
    }
}

