/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public final class PositionRange
extends ComputedExpression {
    private int minPosition;
    private int maxPosition;

    public PositionRange(int n, int n2) {
        this.minPosition = n;
        this.maxPosition = n2;
    }

    public Expression simplify() throws XPathException {
        return this;
    }

    public Expression analyze(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = xPathContext.getContextPosition();
        return BooleanValue.get(n >= this.minPosition && n <= this.maxPosition);
    }

    public int getItemType() {
        return 102;
    }

    public int computeCardinality() {
        return 512;
    }

    public int getIntrinsicDependencies() {
        return 4;
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "positionRange(" + this.minPosition + "," + this.maxPosition + ")");
    }
}

