/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.xpath.XPathException;

public class PositionIterator
implements SequenceIterator {
    private SequenceIterator base;
    private int position = 0;
    private int min = 1;
    private int max = Integer.MAX_VALUE;
    private Item nextItem = null;
    private Item current = null;

    public static SequenceIterator make(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(n, n2);
        }
        return new PositionIterator(sequenceIterator, n, n2);
    }

    private PositionIterator(SequenceIterator sequenceIterator, int n, int n2) throws XPathException {
        this.base = sequenceIterator;
        this.min = n;
        if (n < 1) {
            n = 1;
        }
        this.max = n2;
        if (n2 < n) {
            this.nextItem = null;
            return;
        }
        int n3 = 1;
        while (n3++ <= n) {
            if (sequenceIterator.hasNext()) {
                this.nextItem = sequenceIterator.next();
                continue;
            }
            this.nextItem = null;
            break;
        }
        this.current = this.nextItem;
    }

    public boolean hasNext() throws XPathException {
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        this.current = this.nextItem;
        ++this.position;
        this.nextItem = this.base.position() < this.max && this.base.hasNext() ? this.base.next() : null;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new PositionIterator(this.base.getAnother(), this.min, this.max);
    }
}

