/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.xpath.XPathException;

public class IntersectionEnumeration
implements SequenceIterator {
    private SequenceIterator e1;
    private SequenceIterator e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private NodeOrderComparer comparer;
    private NodeInfo nextNode = null;
    private NodeInfo current = null;
    private int position = 0;

    public IntersectionEnumeration(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.e1 = sequenceIterator;
        this.e2 = sequenceIterator2;
        this.comparer = nodeOrderComparer;
        if (this.e1.hasNext()) {
            this.nextNode1 = this.next(this.e1);
        }
        if (this.e2.hasNext()) {
            this.nextNode2 = this.next(this.e2);
        }
        this.advance();
    }

    private NodeInfo next(SequenceIterator sequenceIterator) throws XPathException {
        return (NodeInfo)sequenceIterator.next();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Item next() throws XPathException {
        this.current = this.nextNode;
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    private void advance() throws XPathException {
        while (this.nextNode1 != null && this.nextNode2 != null) {
            NodeInfo nodeInfo;
            int n = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (n < 0) {
                nodeInfo = this.nextNode1;
                if (this.e1.hasNext()) {
                    this.nextNode1 = this.next(this.e1);
                    continue;
                }
                this.nextNode1 = null;
                this.nextNode = null;
                continue;
            }
            if (n > 0) {
                nodeInfo = this.nextNode2;
                if (this.e2.hasNext()) {
                    this.nextNode2 = this.next(this.e2);
                    continue;
                }
                this.nextNode2 = null;
                this.nextNode = null;
                continue;
            }
            this.nextNode = this.nextNode2;
            this.nextNode2 = this.e2.hasNext() ? this.next(this.e2) : null;
            this.nextNode1 = this.e1.hasNext() ? this.next(this.e1) : null;
            return;
        }
        this.nextNode = null;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new IntersectionEnumeration(this.e1.getAnother(), this.e2.getAnother(), this.comparer);
    }
}

