/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class IfExpression
extends ComputedExpression {
    private Expression condition;
    private Expression thenExp;
    private Expression elseExp;

    public IfExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.thenExp = expression2;
        this.elseExp = expression3;
    }

    public Expression simplify() throws XPathException {
        this.condition = this.condition.simplify();
        if (this.condition instanceof Value) {
            return this.condition.effectiveBooleanValue(null) ? this.thenExp.simplify() : this.elseExp.simplify();
        }
        this.thenExp = this.thenExp.simplify();
        this.elseExp = this.elseExp.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.condition = this.condition.analyze(staticContext);
        this.thenExp = this.thenExp.analyze(staticContext);
        this.elseExp = this.elseExp.analyze(staticContext);
        return this.simplify();
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.condition = this.condition.promote(promotionOffer);
        if (promotionOffer.action == 13) {
            this.thenExp.promote(promotionOffer);
            this.elseExp.promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.condition, this.thenExp, this.elseExp};
        return expressionArray;
    }

    public boolean markTailFunctionCalls() {
        boolean bl = ExpressionTool.markTailFunctionCalls(this.thenExp);
        boolean bl2 = ExpressionTool.markTailFunctionCalls(this.elseExp);
        return bl || bl2;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.evaluateItem(xPathContext);
        }
        return this.elseExp.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.condition.effectiveBooleanValue(xPathContext)) {
            return this.thenExp.iterate(xPathContext);
        }
        return this.elseExp.iterate(xPathContext);
    }

    public int getItemType() {
        return Type.getCommonSuperType(this.thenExp.getItemType(), this.elseExp.getItemType());
    }

    public int computeCardinality() {
        return Cardinality.union(this.thenExp.getCardinality(), this.elseExp.getCardinality());
    }

    public int ComputeSpecialProperties() {
        return this.thenExp.getSpecialProperties() & this.elseExp.getSpecialProperties();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "if (");
        this.condition.display(n + 1);
        System.err.println(ExpressionTool.indent(n) + "then");
        this.thenExp.display(n + 1);
        System.err.println(ExpressionTool.indent(n) + "else");
        this.elseExp.display(n + 1);
    }
}

