/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.xpath.XPathException;

public final class FirstItemExpression
extends ComputedExpression {
    private Expression base;

    public FirstItemExpression(Expression expression) {
        this.base = expression;
        this.computeStaticProperties();
    }

    public int getItemType() {
        return this.base.getItemType();
    }

    public Expression simplify() throws XPathException {
        this.base = this.base.simplify();
        if (!Cardinality.allowsMany(this.base.getCardinality())) {
            return this.base;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.base = this.base.analyze(staticContext);
        if (!Cardinality.allowsMany(this.base.getCardinality())) {
            return this.base;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.base = this.base.promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.base};
        return expressionArray;
    }

    public int computeCardinality() {
        int n = this.base.getCardinality() & 0xFFFFFBFF;
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof FirstItemExpression) {
            FirstItemExpression firstItemExpression = (FirstItemExpression)object;
            return this.base.equals(firstItemExpression.base);
        }
        return false;
    }

    public int hashCode() {
        return "FirstItemExpression".hashCode() + this.base.hashCode();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.base.iterate(xPathContext);
        if (sequenceIterator.hasNext()) {
            return sequenceIterator.next();
        }
        return null;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "first item of ");
        this.base.display(n + 1);
    }
}

