/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.xpath.XPathException;

public class DifferenceEnumeration
implements SequenceIterator {
    private SequenceIterator p1;
    private SequenceIterator p2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private NodeOrderComparer comparer;
    private NodeInfo nextNode = null;
    private NodeInfo current = null;
    private int position = 0;

    public DifferenceEnumeration(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.p1 = sequenceIterator;
        this.p2 = sequenceIterator2;
        this.comparer = nodeOrderComparer;
        if (sequenceIterator.hasNext()) {
            this.nextNode1 = this.next(sequenceIterator);
        }
        if (sequenceIterator2.hasNext()) {
            this.nextNode2 = this.next(sequenceIterator2);
        }
        this.advance();
    }

    private NodeInfo next(SequenceIterator sequenceIterator) throws XPathException {
        return (NodeInfo)sequenceIterator.next();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Item next() throws XPathException {
        this.current = this.nextNode;
        ++this.position;
        this.advance();
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    private void advance() throws XPathException {
        while (this.nextNode1 != null && this.nextNode2 != null) {
            int n = this.comparer.compare(this.nextNode1, this.nextNode2);
            if (n < 0) {
                NodeInfo nodeInfo = this.nextNode1;
                if (this.p1.hasNext()) {
                    this.nextNode1 = this.next(this.p1);
                } else {
                    this.nextNode1 = null;
                    this.nextNode = null;
                }
                this.nextNode = nodeInfo;
                return;
            }
            if (n > 0) {
                if (this.p2.hasNext()) {
                    this.nextNode2 = this.next(this.p2);
                    continue;
                }
                this.nextNode2 = null;
                this.nextNode = null;
                continue;
            }
            this.nextNode2 = this.p2.hasNext() ? this.next(this.p2) : null;
            this.nextNode1 = this.p1.hasNext() ? this.next(this.p1) : null;
        }
        if (this.nextNode1 != null) {
            this.nextNode = this.nextNode1;
            this.nextNode1 = this.p1.hasNext() ? this.next(this.p1) : null;
            return;
        }
        this.nextNode = null;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new DifferenceEnumeration(this.p1.getAnother(), this.p2.getAnother(), this.comparer);
    }
}

