/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.ElementImpl;

public class Stripper
extends ProxyReceiver {
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private ElementImpl element = new ElementImpl();
    private Controller controller;
    private NamePool namePool;
    private int xmlSpaceCode;

    protected Stripper() {
    }

    public Stripper(Mode mode) {
        this.stripperMode = mode;
        this.preserveAll = mode == null;
        this.stripAll = false;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.namePool = controller.getNamePool();
        this.xmlSpaceCode = this.namePool.allocate("xml", "http://www.w3.org/XML/1998/namespace", "space");
    }

    public boolean isSpacePreserving(int n) {
        try {
            if (this.preserveAll) {
                return true;
            }
            if (this.stripAll) {
                return false;
            }
            this.element.setNameCode(n);
            Object object = this.stripperMode.getRule(this.element, this.controller);
            if (object == null) {
                return true;
            }
            return (Boolean)object;
        }
        catch (TransformerException transformerException) {
            return true;
        }
    }

    public void startDocument() throws TransformerException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.startDocument();
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        byte by = this.stripStack[this.top];
        byte by2 = (byte)(by & 2);
        if (this.isSpacePreserving(n)) {
            by2 = (byte)(by2 | 1);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] byArray = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, byArray, 0, this.top);
            this.stripStack = byArray;
        }
        this.stripStack[this.top] = by2;
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        if (n == this.xmlSpaceCode && string.equals("preserve")) {
            int n4 = this.top;
            this.stripStack[n4] = (byte)(this.stripStack[n4] | 2);
        }
        super.attribute(n, n2, string, n3);
    }

    public void endElement() throws TransformerException {
        super.endElement();
        --this.top;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (!(charSequence.length() <= 0 || this.stripStack[this.top] == 0 && Navigator.isWhite(charSequence))) {
            super.characters(charSequence, n);
        }
    }
}

