/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;

public class NamespaceReducer
extends ProxyReceiver {
    private int nscodeXML;
    private int nscodeNull;
    private int[] namespaces = new int[30];
    private int namespacesSize = 0;
    private int[] namespaceStack = new int[100];
    private int nsStackTop = 0;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.nscodeXML = namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace");
        this.nscodeNull = namePool.getNamespaceCode("", "");
        super.setNamePool(namePool);
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        this.namespaceStack[this.nsStackTop] = 0;
        if (++this.nsStackTop >= this.namespaceStack.length) {
            int[] nArray = new int[this.nsStackTop * 2];
            System.arraycopy(this.namespaceStack, 0, nArray, 0, this.nsStackTop);
            this.namespaceStack = nArray;
        }
        if ((n3 & 0x40) == 0) {
            this.namespace(this.namePool.allocateNamespaceCode(n), 0);
        }
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.isNeeded(n)) {
            this.addToStack(n);
            int n3 = this.nsStackTop - 1;
            this.namespaceStack[n3] = this.namespaceStack[n3] + 1;
            super.namespace(n, n2);
        }
    }

    private boolean isNeeded(int n) {
        if (n == this.nscodeXML) {
            return false;
        }
        int n2 = this.namespacesSize - 1;
        while (n2 >= 0) {
            if (this.namespaces[n2] == n) {
                return false;
            }
            if (this.namespaces[n2] >> 16 == n >> 16) {
                return true;
            }
            --n2;
        }
        return n != this.nscodeNull;
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void endElement() throws TransformerException {
        if (this.nsStackTop-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int n = this.namespaceStack[this.nsStackTop];
        this.namespacesSize -= n;
        super.endElement();
    }
}

