/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Loader;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.CharacterSetFactory;
import net.sf.saxon.charcode.PluggableCharacterSet;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public abstract class Emitter
implements Result,
Receiver {
    protected NamePool namePool;
    protected String systemId;
    protected Writer writer;
    protected OutputStream outputStream;
    protected Properties outputProperties;
    protected Locator locator;
    protected CharacterSet characterSet = null;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setOutputProperties(Properties properties) throws TransformerException {
        if (this.characterSet == null) {
            this.characterSet = CharacterSetFactory.getCharacterSet(properties);
        }
        this.outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        if (writer instanceof OutputStreamWriter && this.outputProperties != null) {
            String string = ((OutputStreamWriter)writer).getEncoding();
            this.outputProperties.put("encoding", string);
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputStream(OutputStream outputStream) throws TransformerException {
        this.outputStream = outputStream;
        if (this.usesWriter()) {
            String string = this.outputProperties.getProperty("encoding");
            if (string == null) {
                string = "UTF8";
            }
            if (string.equalsIgnoreCase("UTF-8")) {
                string = "UTF8";
            }
            if (this.characterSet instanceof PluggableCharacterSet) {
                string = ((PluggableCharacterSet)this.characterSet).getEncodingName();
            }
            while (true) {
                try {
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, string));
                }
                catch (Exception exception) {
                    if (string.equalsIgnoreCase("UTF8")) {
                        throw new TransformerException("Failed to create a UTF8 output writer");
                    }
                    System.err.println("Encoding " + string + " is not supported: using UTF8");
                    string = "UTF8";
                    this.characterSet = UnicodeCharacterSet.getInstance();
                    this.outputProperties.put("encoding", "UTF-8");
                    continue;
                }
                break;
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws TransformerException {
    }

    public static Emitter makeEmitter(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof Emitter) {
            return (Emitter)object;
        }
        if (object instanceof ContentHandler) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler((ContentHandler)object);
            return contentHandlerProxy;
        }
        throw new TransformerException("Failed to load emitter " + string + ": it is neither an Emitter nor a SAX2 ContentHandler");
    }
}

