/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.Version;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryProcessor;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.SimpleTraceListener;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.InputSource;

public class Query {
    public static void main(String[] stringArray) throws Exception {
        new Query().doMain(stringArray, " java net.sf.saxon.Query");
    }

    protected void doMain(String[] stringArray, String string) {
        Configuration configuration = new Configuration();
        configuration.setHostLanguage(11);
        boolean bl = false;
        int n = 1;
        StaticQueryContext staticQueryContext = new StaticQueryContext();
        staticQueryContext.setConfiguration(configuration);
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext();
        String string2 = null;
        String string3 = null;
        File file = null;
        File file2 = null;
        boolean bl2 = false;
        String string4 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Properties properties = new Properties();
        properties.setProperty("indent", "yes");
        try {
            XQueryExpression xQueryExpression;
            InputStreamReader inputStreamReader;
            Object object;
            Object object2;
            int n2 = 0;
            while (true) {
                if (n2 >= stringArray.length) {
                    this.badUsage(string, "No source file name");
                }
                if (stringArray[n2].charAt(0) != '-') break;
                if (stringArray[n2].equals("-ds")) {
                    configuration.setTreeModel(0);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-dt")) {
                    configuration.setTreeModel(1);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-e")) {
                    bl3 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-l")) {
                    configuration.setLineNumbering(true);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-3")) {
                    ++n2;
                    n = 3;
                    continue;
                }
                if (stringArray[n2].equals("-9")) {
                    ++n2;
                    n = 9;
                    continue;
                }
                if (stringArray[n2].equals("-noext")) {
                    ++n2;
                    configuration.setAllowExternalFunctions(false);
                    continue;
                }
                if (stringArray[n2].equals("-o")) {
                    if (stringArray.length < ++n2 + 2) {
                        this.badUsage(string, "No output file name");
                    }
                    string4 = stringArray[n2++];
                    continue;
                }
                if (stringArray[n2].equals("-r")) {
                    if (stringArray.length < ++n2 + 2) {
                        this.badUsage(string, "No URIResolver class");
                    }
                    String string5 = stringArray[n2++];
                    configuration.setURIResolver(Query.makeURIResolver(string5));
                    dynamicQueryContext.setURIResolver(Query.makeURIResolver(string5));
                    continue;
                }
                if (stringArray[n2].equals("-s")) {
                    if (stringArray.length < ++n2 + 2) {
                        this.badUsage(string, "No source file name");
                    }
                    string2 = stringArray[n2++];
                    continue;
                }
                if (stringArray[n2].equals("-strip")) {
                    configuration.setStripsAllWhiteSpace(true);
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-t")) {
                    System.err.println(Version.getProductTitle());
                    System.err.println("Java version " + System.getProperty("java.version"));
                    Loader.setTracing(true);
                    configuration.setTiming(true);
                    bl = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-T")) {
                    configuration.setTraceListener(new SimpleTraceListener());
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-TJ")) {
                    ++n2;
                    configuration.setTraceExternalFunctions(true);
                    continue;
                }
                if (stringArray[n2].equals("-u")) {
                    bl2 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-wrap")) {
                    bl4 = true;
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-?")) {
                    this.badUsage(string, "");
                    continue;
                }
                this.badUsage(string, "Unknown option " + stringArray[n2]);
            }
            if (stringArray.length < n2 + 1) {
                this.badUsage(string, "No query file name");
            }
            string3 = stringArray[n2++];
            int n3 = n2;
            while (n3 < stringArray.length) {
                object2 = stringArray[n3];
                int n4 = ((String)object2).indexOf("=");
                if (n4 < 1 || n4 >= ((String)object2).length() - 1) {
                    this.badUsage(string, "Bad param=value pair on command line");
                }
                if (((String)(object = ((String)object2).substring(0, n4))).startsWith("!")) {
                    properties.setProperty(((String)object).substring(1), ((String)object2).substring(n4 + 1));
                } else {
                    dynamicQueryContext.setParameter((String)object, new StringValue(((String)object2).substring(n4 + 1)));
                }
                ++n3;
            }
            object2 = null;
            if (string2 != null) {
                if (bl2 || string2.startsWith("http:") || string2.startsWith("file:")) {
                    object2 = dynamicQueryContext.getURIResolver().resolve(string2, null);
                } else if (string2.equals("-")) {
                    object2 = new SAXSource(new InputSource(System.in));
                } else {
                    file = new File(string2);
                    if (!file.exists()) {
                        Query.quit("Source file " + file + " does not exist", 2);
                    }
                    InputSource inputSource = new InputSource(file.toURI().toString());
                    object2 = new SAXSource(inputSource);
                }
            }
            if (string3.equals("-")) {
                inputStreamReader = new InputStreamReader(System.in);
            } else {
                inputStreamReader = new FileReader(string3);
                staticQueryContext.setBaseURI(new File(string3).toURI().toString());
            }
            if (string4 != null) {
                file2 = new File(string4);
                if (file2.isDirectory()) {
                    Query.quit("Output is a directory", 2);
                }
                object = new FileOutputStream(file2);
            } else {
                object = System.out;
            }
            QueryProcessor queryProcessor = new QueryProcessor(configuration, staticQueryContext);
            long l = new Date().getTime();
            try {
                if (bl) {
                    System.err.println("Compiling query from " + string3);
                }
                xQueryExpression = queryProcessor.compileQuery(inputStreamReader);
                if (bl) {
                    long l2 = new Date().getTime();
                    System.err.println("Compilation time: " + (l2 - l) + " milliseconds");
                    l = l2;
                }
            }
            catch (XPathException xPathException) {
                int n5 = -1;
                if (xPathException.getLocator() != null) {
                    n5 = xPathException.getLocator().getLineNumber();
                }
                if (n5 == -1) {
                    System.err.println("Failed to compile query: " + xPathException.getMessage());
                } else {
                    System.err.println("Syntax error at line " + n5 + ":");
                    System.err.println(xPathException.getMessage());
                }
                throw new TransformerException(xPathException);
            }
            if (bl3) {
                staticQueryContext.explainGlobalFunctions();
                xQueryExpression.explain();
            }
            int n6 = 0;
            while (n6 < n) {
                if (object2 != null) {
                    if (bl) {
                        System.err.println("Processing " + object2.getSystemId());
                    }
                    DocumentInfo documentInfo = queryProcessor.buildDocument((Source)object2);
                    dynamicQueryContext.setContextNode(documentInfo);
                }
                try {
                    Object object3;
                    SequenceIterator sequenceIterator = xQueryExpression.iterator(dynamicQueryContext);
                    if (bl4) {
                        object3 = QueryResult.wrap(sequenceIterator, NamePool.getDefaultNamePool());
                        QueryResult.serialize((NodeInfo)object3, new StreamResult((OutputStream)object), properties);
                        ((OutputStream)object).close();
                    } else {
                        object3 = new PrintWriter((OutputStream)object);
                        while (sequenceIterator.hasNext()) {
                            Item item = sequenceIterator.next();
                            switch (item.getItemType()) {
                                case 1: 
                                case 9: {
                                    QueryResult.serialize(((NodeInfo)item).getRoot(), new StreamResult((Writer)object3), properties);
                                    ((PrintWriter)object3).println("");
                                    break;
                                }
                                default: {
                                    ((PrintWriter)object3).println(item.getStringValue());
                                }
                            }
                        }
                        ((PrintWriter)object3).close();
                    }
                }
                catch (TerminationException terminationException) {
                    throw terminationException;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerException("Run-time errors were reported");
                }
                if (bl) {
                    long l3 = new Date().getTime();
                    System.err.println("Execution time: " + (l3 - l) + " milliseconds");
                    l = l3;
                }
                ++n6;
            }
        }
        catch (TerminationException terminationException) {
            Query.quit(terminationException.getMessage(), 1);
        }
        catch (TransformerException transformerException) {
            Query.quit("Query processing failed", 2);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
            Query.quit("Query processing failed", 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Query.quit("Fatal error during transformation: " + exception.getMessage(), 2);
        }
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    protected void badUsage(String string, String string2) {
        if (!"".equals(string2)) {
            System.err.println(string2);
        }
        System.err.println(Version.getProductTitle());
        System.err.println("Usage: " + string + " [options] style-doc {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -ds             Use standard tree data structure");
        System.err.println("  -dt             Use tinytree data structure (default)");
        System.err.println("  -e              Explain optimized query expression");
        System.err.println("  -noext          Disallow calls to Java methods");
        System.err.println("  -o filename     Send output to named file");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -s file|URI     Provide input() document");
        System.err.println("  -strip          Strip whitespace text nodes");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -T              Trace query execution");
        System.err.println("  -TJ             Trace calls to external Java functions");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -wrap           Wraps result sequence in XML elements");
        System.err.println("  -?              Display this message ");
        System.err.println("  param=value     Set stylesheet parameter");
        System.err.println("  !option=value   Set serialization option");
        if ("".equals(string2)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    public static URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new TransformerException("Class " + string + " is not a URIResolver");
    }
}

