/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.Sender;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(Configuration configuration) {
        super(configuration);
    }

    public void transform(Source source, Result result) throws TransformerException {
        NamePool namePool = NamePool.getDefaultNamePool();
        if (source instanceof DocumentInfo) {
            namePool = ((DocumentInfo)source).getNamePool();
        }
        OutputURIResolver outputURIResolver = this.getConfiguration().getOutputURIResolver();
        Receiver receiver = ResultWrapper.getReceiver(result, outputURIResolver, namePool, this.getOutputProperties(), null);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        new Sender(this.getConfiguration()).send(source, namespaceReducer, namePool, false);
    }
}

