/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Comparator;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class UntypedAtomicValue
extends StringValue {
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public int getItemType() {
        return 125;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return true;
    }

    public AtomicValue convert(int n) throws XPathException {
        if (n == 101) {
            return new StringValue(this.value);
        }
        if (n == 105) {
            if (this.doubleValue == null) {
                this.doubleValue = (DoubleValue)super.convert(n);
            }
            return this.doubleValue;
        }
        return super.convert(n);
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convert(105);
                }
                catch (XPathException xPathException) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValue() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(object);
        }
        if (object instanceof StringValue) {
            return comparator.compare(this.getStringValue(), ((StringValue)object).getStringValue());
        }
        if (object instanceof Value) {
            try {
                AtomicValue atomicValue = this.convert(((Value)object).getItemType());
                if (!(atomicValue instanceof Comparable)) {
                    throw new XPathException.Dynamic("Type " + Type.getTypeName(((Value)object).getItemType()) + " is not ordered");
                }
                return ((Comparable)((Object)atomicValue)).compareTo(object);
            }
            catch (XPathException xPathException) {
                throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + Type.getTypeName(((Value)object).getItemType()));
            }
        }
        return comparator.compare(this.getStringValue(), object.toString());
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "untyped (\"" + this.value + "\")");
    }
}

