/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.xpath.XPathException;

public abstract class Type
implements Serializable {
    private static HashMap hierarchy = new HashMap(100);
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short NODE = 0;
    public static final short ITEM = 88;
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;
    public static final int ATOMIC = 90;
    public static final int NUMBER = 91;
    public static final int ANY_SIMPLE_TYPE = 92;
    public static final int ANY_TYPE = 93;
    public static final int UNTYPED_ANY = 94;
    public static final int STRING = 101;
    public static final int BOOLEAN = 102;
    public static final int DECIMAL = 103;
    public static final int FLOAT = 104;
    public static final int DOUBLE = 105;
    public static final int DURATION = 106;
    public static final int DATE_TIME = 107;
    public static final int TIME = 108;
    public static final int DATE = 109;
    public static final int G_YEAR_MONTH = 110;
    public static final int G_YEAR = 111;
    public static final int G_MONTH_DAY = 112;
    public static final int G_DAY = 113;
    public static final int G_MONTH = 114;
    public static final int HEX_BINARY = 115;
    public static final int BASE64_BINARY = 116;
    public static final int ANY_URI = 117;
    public static final int QNAME = 118;
    public static final int NOTATION = 119;
    public static final int UNTYPED_ATOMIC = 125;
    public static final int OBJECT = 130;
    public static final int INTEGER = 200;
    public static final int NON_POSITIVE_INTEGER = 201;
    public static final int NEGATIVE_INTEGER = 202;
    public static final int LONG = 203;
    public static final int INT = 204;
    public static final int SHORT = 205;
    public static final int BYTE = 206;
    public static final int NON_NEGATIVE_INTEGER = 207;
    public static final int POSITIVE_INTEGER = 208;
    public static final int UNSIGNED_LONG = 209;
    public static final int UNSIGNED_INT = 210;
    public static final int UNSIGNED_SHORT = 211;
    public static final int UNSIGNED_BYTE = 212;
    public static final int NORMALIZED_STRING = 220;
    public static final int TOKEN = 221;
    public static final int LANGUAGE = 222;
    public static final int NMTOKEN = 223;
    public static final int NMTOKENS = 224;
    public static final int NAME = 225;
    public static final int NCNAME = 226;
    public static final int ID = 227;
    public static final int IDREF = 228;
    public static final int IDREFS = 229;
    public static final int ENTITY = 230;
    public static final int ENTITIES = 231;
    public static final int YEAR_MONTH_DURATION = 240;
    public static final int DAY_TIME_DURATION = 241;
    public static final int SAME_AS_FIRST_ARGUMENT = 999999;
    static String[] typeName = new String[255];
    static HashMap typeTable = new HashMap(255);

    public static boolean isNodeType(int n) {
        return n < 13;
    }

    static void defineBuiltInType(int n, String string) {
        Type.typeName[n] = string;
        typeTable.put(string, new Integer(n));
    }

    static void defineType(int n, String string) {
        Type.typeName[n] = string;
        typeTable.put(string, new Integer(n));
    }

    public static final String getTypeName(int n) {
        if (n <= 255) {
            return typeName[n];
        }
        return "" + n;
    }

    private static final int getType(String string) throws XPathException {
        Integer n = (Integer)typeTable.get(string);
        if (n == null) {
            throw new XPathException.Static("Unknown type " + string);
        }
        return n;
    }

    private static void defineSubType(int n, int n2) {
        hierarchy.put(new Integer(n2), new Integer(n));
    }

    private static int getSuperType(int n) {
        Object v = hierarchy.get(new Integer(n));
        if (v == null) {
            throw new IllegalArgumentException("No supertype for type " + n);
        }
        return (Integer)v;
    }

    public static boolean isSubType(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n2 == 88) {
            return true;
        }
        if (n == 88) {
            return false;
        }
        if (n == 15) {
            return true;
        }
        int n3 = Type.getSuperType(n);
        return Type.isSubType(n3, n2);
    }

    public static boolean isPromotable(int n, int n2) {
        if (Type.isSubType(n, 103)) {
            return n2 == 104 || n2 == 105;
        }
        if (Type.isSubType(n2, 104)) {
            return n2 == 105;
        }
        return false;
    }

    public static int getPrimitiveType(int n) {
        if (n == 88) {
            throw new IllegalArgumentException("Supplied type " + n + " is not atomic");
        }
        int n2 = Type.getSuperType(n);
        if (n2 == 90) {
            return n;
        }
        return Type.getPrimitiveType(n2);
    }

    public static final int getCommonSuperType(int n, int n2) {
        if (n == 15) {
            return n2;
        }
        if (n2 == 15) {
            return n;
        }
        if (n == n2) {
            return n;
        }
        if (Type.isSubType(n, n2)) {
            return n2;
        }
        if (Type.isSubType(n2, n)) {
            return n;
        }
        return Type.getCommonSuperType(Type.getSuperType(n2), n);
    }

    public static int getNamedType(String string, String string2) throws XPathException {
        if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            return Type.getType("xs:" + string2);
        }
        if (string.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            return Type.getType("xdt:" + string2);
        }
        throw new XPathException.Static("Unknown type " + (string.equals("") ? "" : "{" + string + "}") + string2);
    }

    public static int getSystemType(String string) throws XPathException {
        if (string.equals("item")) {
            return 88;
        }
        if (string.equals("document-node")) {
            return 9;
        }
        if (string.equals("element")) {
            return 1;
        }
        if (string.equals("attribute")) {
            return 2;
        }
        if (string.equals("text")) {
            return 3;
        }
        if (string.equals("comment")) {
            return 8;
        }
        if (string.equals("processing-instruction")) {
            return 7;
        }
        if (string.equals("namespace")) {
            return 13;
        }
        if (string.equals("node")) {
            return 0;
        }
        if (string.equals("empty")) {
            return 15;
        }
        throw new XPathException.Static("Unknown type " + string);
    }

    static {
        Type.defineType(88, "item");
        Type.defineType(0, "node");
        Type.defineType(1, "element");
        Type.defineType(9, "document");
        Type.defineType(2, "attribute");
        Type.defineType(3, "text");
        Type.defineType(8, "comment");
        Type.defineType(7, "processing-instruction");
        Type.defineType(13, "namespace");
        Type.defineType(15, "empty");
        Type.defineType(91, "number");
        Type.defineBuiltInType(125, "xdt:untypedAtomic");
        Type.defineBuiltInType(90, "xdt:anyAtomicType");
        Type.defineBuiltInType(240, "xdt:yearMonthDuration");
        Type.defineBuiltInType(241, "xdt:dayTimeDuration");
        Type.defineBuiltInType(101, "xs:string");
        Type.defineBuiltInType(102, "xs:boolean");
        Type.defineBuiltInType(103, "xs:decimal");
        Type.defineBuiltInType(104, "xs:float");
        Type.defineBuiltInType(105, "xs:double");
        Type.defineBuiltInType(106, "xs:duration");
        Type.defineBuiltInType(107, "xs:dateTime");
        Type.defineBuiltInType(108, "xs:time");
        Type.defineBuiltInType(109, "xs:date");
        Type.defineBuiltInType(110, "xs:gYearMonth");
        Type.defineBuiltInType(111, "xs:gYear");
        Type.defineBuiltInType(112, "xs:gMonthDay");
        Type.defineBuiltInType(113, "xs:gDay");
        Type.defineBuiltInType(114, "xs:gMonth");
        Type.defineBuiltInType(115, "xs:hexBinary");
        Type.defineBuiltInType(116, "xs:base64Binary");
        Type.defineBuiltInType(117, "xs:anyURI");
        Type.defineBuiltInType(118, "xs:QName");
        Type.defineBuiltInType(119, "xs:NOTATION");
        Type.defineBuiltInType(200, "xs:integer");
        Type.defineBuiltInType(201, "xs:nonPositiveInteger");
        Type.defineBuiltInType(202, "xs:negativeInteger");
        Type.defineBuiltInType(203, "xs:long");
        Type.defineBuiltInType(204, "xs:int");
        Type.defineBuiltInType(205, "xs:short");
        Type.defineBuiltInType(206, "xs:byte");
        Type.defineBuiltInType(207, "xs:nonNegativeInteger");
        Type.defineBuiltInType(208, "xs:positiveInteger");
        Type.defineBuiltInType(209, "xs:unsignedLong");
        Type.defineBuiltInType(210, "xs:unsignedInt");
        Type.defineBuiltInType(211, "xs:unsignedShort");
        Type.defineBuiltInType(212, "xs:unsignedByte");
        Type.defineBuiltInType(220, "xs:normalizedString");
        Type.defineBuiltInType(221, "xs:token");
        Type.defineBuiltInType(222, "xs:language");
        Type.defineBuiltInType(223, "xs:NMTOKEN");
        Type.defineBuiltInType(224, "xs:NMTOKENS");
        Type.defineBuiltInType(225, "xs:Name");
        Type.defineBuiltInType(226, "xs:NCName");
        Type.defineBuiltInType(227, "xs:ID");
        Type.defineBuiltInType(228, "xs:IDREF");
        Type.defineBuiltInType(229, "xs:IDREFS");
        Type.defineBuiltInType(230, "xs:ENTITY");
        Type.defineBuiltInType(231, "xs:ENTITIES");
        Type.defineBuiltInType(130, "object");
        Type.defineSubType(88, 0);
        Type.defineSubType(0, 1);
        Type.defineSubType(0, 2);
        Type.defineSubType(0, 9);
        Type.defineSubType(0, 3);
        Type.defineSubType(0, 8);
        Type.defineSubType(0, 7);
        Type.defineSubType(0, 13);
        Type.defineSubType(88, 90);
        Type.defineSubType(90, 101);
        Type.defineSubType(90, 102);
        Type.defineSubType(90, 91);
        Type.defineSubType(90, 106);
        Type.defineSubType(90, 107);
        Type.defineSubType(90, 108);
        Type.defineSubType(90, 109);
        Type.defineSubType(90, 110);
        Type.defineSubType(90, 111);
        Type.defineSubType(90, 112);
        Type.defineSubType(90, 113);
        Type.defineSubType(90, 114);
        Type.defineSubType(90, 115);
        Type.defineSubType(90, 116);
        Type.defineSubType(90, 117);
        Type.defineSubType(90, 118);
        Type.defineSubType(90, 119);
        Type.defineSubType(90, 125);
        Type.defineSubType(90, 130);
        Type.defineSubType(91, 103);
        Type.defineSubType(91, 105);
        Type.defineSubType(91, 104);
        Type.defineSubType(103, 200);
        Type.defineSubType(200, 201);
        Type.defineSubType(201, 202);
        Type.defineSubType(200, 203);
        Type.defineSubType(203, 204);
        Type.defineSubType(204, 205);
        Type.defineSubType(205, 206);
        Type.defineSubType(200, 207);
        Type.defineSubType(207, 208);
        Type.defineSubType(207, 209);
        Type.defineSubType(209, 210);
        Type.defineSubType(210, 211);
        Type.defineSubType(211, 212);
        Type.defineSubType(106, 240);
        Type.defineSubType(106, 241);
        Type.defineSubType(101, 220);
        Type.defineSubType(220, 221);
        Type.defineSubType(221, 222);
        Type.defineSubType(221, 225);
        Type.defineSubType(221, 223);
        Type.defineSubType(225, 226);
        Type.defineSubType(226, 227);
        Type.defineSubType(226, 228);
        Type.defineSubType(226, 230);
    }
}

