/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class TimeValue
extends CalendarValue
implements Comparable {
    private GregorianCalendar calendar;
    private boolean zoneSpecified = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public TimeValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.collapseWhitespace(charSequence).toString(), "-:.+Z", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            String string = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("hour must be two digits");
            }
            if (n > 23) {
                this.badTime("hour is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!stringTokenizer.nextElement().equals(":")) {
                this.badTime("wrong delimiter after hour");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n2 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("minute must be two digits");
            }
            if (n2 > 59) {
                this.badTime("minute is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!stringTokenizer.nextElement().equals(":")) {
                this.badTime("wrong delimiter after minute");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("second must be two digits");
            }
            if (n > 61) {
                this.badTime("second is out of range");
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (stringTokenizer.hasMoreElements()) {
                if (n6 == 9) {
                    this.badTime("characters after the end");
                }
                if (((String)(object = (String)stringTokenizer.nextElement())).equals(".")) {
                    if (n6 != 0) {
                        this.badTime("decimal separator occurs twice");
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() < 3) {
                        string = string + "00";
                    }
                    if (string.length() > 3) {
                        string = string.substring(0, 3);
                    }
                    n4 = Integer.parseInt(string);
                    n6 = 1;
                    continue;
                }
                if (((String)object).equals("Z")) {
                    if (n6 > 1) {
                        this.badTime("Z cannot occur here");
                    }
                    this.zoneSpecified = true;
                    n5 = 0;
                    n6 = 9;
                    continue;
                }
                if (((String)object).equals("+") || ((String)object).equals("-")) {
                    if (n6 > 1) {
                        this.badTime((String)object + " cannot occur here");
                    }
                    n6 = 2;
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badTime("missing timezone");
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badTime("timezone hour must be two digits");
                    }
                    if ((n5 = Integer.parseInt(string) * 60) > 840) {
                        this.badTime("timezone hour is out of range");
                    }
                    if (!((String)object).equals("-")) continue;
                    n5 = -n5;
                    continue;
                }
                if (((String)object).equals(":")) {
                    if (n6 != 2) {
                        this.badTime("colon cannot occur here");
                    }
                    n6 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n7 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badTime("timezone minute must be two digits");
                    }
                    if (n7 > 59) {
                        this.badTime("timezone minute is out of range");
                    }
                    if (n5 < 0) {
                        n7 = -n7;
                    }
                    n5 += n7;
                    continue;
                }
                this.badTime("timezone format is incorrect");
            }
            if (n6 == 2 || n6 == 3) {
                this.badTime("timezone incomplete");
            }
            object = new SimpleTimeZone(n5 * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.setLenient(false);
            this.calendar.set(2000, 0, 1, n, n2, n3);
            this.calendar.set(14, n4);
            this.calendar.set(15, n5 * 60000);
            this.calendar.set(16, 0);
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badTime("time components out of range");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badTime("non-numeric component");
        }
    }

    private void badTime(String string) throws XPathException {
        throw new XPathException.Dynamic("Invalid time value (" + string + ")");
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 90: 
            case 108: {
                return this;
            }
            case 101: {
                return new StringValue(this.getStringValue());
            }
            case 107: {
                return new DateTimeValue(this.calendar, this.zoneSpecified);
            }
        }
        throw new XPathException.Dynamic("Cannot convert time to " + Type.getTypeName(n));
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        DateTimeValue.appendString(stringBuffer, this.calendar.get(11), 2);
        stringBuffer.append(':');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(12), 2);
        stringBuffer.append(':');
        DateTimeValue.appendSeconds(this.calendar, stringBuffer);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.calendar, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public int getItemType() {
        return 108;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = TimeValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return 0;
        }
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = TimeValue.class$("java.util.Date")) : class$java$util$Date)) {
            return 1;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TimeValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = TimeValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TimeValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of time to " + clazz.getName() + " is not supported");
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 4: {
                return new IntegerValue(this.calendar.get(11));
            }
            case 5: {
                return new IntegerValue(this.calendar.get(12));
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer();
                DateTimeValue.appendSeconds(this.calendar, stringBuffer);
                return new DecimalValue(stringBuffer.toString());
            }
            case 7: {
                if (this.zoneSpecified) {
                    StringBuffer stringBuffer = new StringBuffer();
                    DateTimeValue.appendTimezone(this.calendar, stringBuffer);
                    return new StringValue(stringBuffer);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + object.getClass());
        }
        GregorianCalendar gregorianCalendar = ((TimeValue)object).calendar;
        return this.calendar.getTime().compareTo(gregorianCalendar.getTime());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.calendar.getTime().hashCode();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "time (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

