/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class QNameValue
extends AtomicValue {
    private String uri;
    private String localName;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$QNameValue;

    public QNameValue(String string, String string2) throws XPathException {
        this.uri = string;
        this.localName = string2;
        if (!XMLChar.isValidNCName(string2)) {
            throw new XPathException.Dynamic("Malformed local name in QName: '" + string2 + "'");
        }
    }

    public String getStringValue() throws XPathException {
        throw new XPathException.Dynamic("QName cannot be converted to string");
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public AtomicValue getComponent(int n) {
        if (n == 8) {
            return new StringValue(this.localName);
        }
        if (n == 9) {
            if (this.uri == null) {
                return null;
            }
            return new StringValue(this.uri);
        }
        throw new UnsupportedOperationException("Component of QName must be URI or Local Name");
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 90: 
            case 118: {
                return this;
            }
        }
        throw new XPathException.Dynamic("Cannot convert QName to " + Type.getTypeName(n));
    }

    public int getItemType() {
        return 118;
    }

    public boolean equals(Object object) {
        QNameValue qNameValue = (QNameValue)object;
        return this.uri.equals(qNameValue.uri) && this.localName.equals(qNameValue.localName);
    }

    public int hashCode() {
        return this.uri.hashCode() ^ this.localName.hashCode();
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = QNameValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$QNameValue == null ? (class$net$sf$saxon$value$QNameValue = QNameValue.class$("net.sf.saxon.value.QNameValue")) : class$net$sf$saxon$value$QNameValue)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$QNameValue == null ? (class$net$sf$saxon$value$QNameValue = QNameValue.class$("net.sf.saxon.value.QNameValue")) : class$net$sf$saxon$value$QNameValue)) {
            return this;
        }
        throw new XPathException.Dynamic("Conversion of anyURI to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "QName (\"{" + this.uri + "}" + this.localName + "\")");
    }

    public String toString() {
        return "\"{" + this.uri + "}" + this.localName + "\"";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

