/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    private double value;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    public DoubleValue(double d) {
        this.value = d;
    }

    public DoubleValue(String string) {
        this.value = Value.stringToNumber(string);
    }

    public double getValue() {
        return this.value;
    }

    public double asDouble() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 102: {
                return BooleanValue.get(this.asBoolean());
            }
            case 88: 
            case 90: 
            case 91: 
            case 105: {
                return this;
            }
            case 200: {
                if (Double.isNaN(this.value)) {
                    throw new XPathException.Dynamic("Cannot convert double NaN to an integer");
                }
                if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
                    throw new XPathException.Dynamic("Double " + this.value + " is too big to convert to xs:integer");
                }
                return new IntegerValue((long)this.value);
            }
            case 103: {
                return new DecimalValue(this.value);
            }
            case 104: {
                return new FloatValue((float)this.value);
            }
            case 101: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException.Dynamic("Cannot convert double to " + Type.getTypeName(n));
    }

    /*
     * Unable to fully structure code
     */
    public String getStringValue() {
        block9: {
            if (!Double.isInfinite(this.value) && (this.value >= 9.007199254740992E15 || -this.value >= 9.007199254740992E15)) {
                return new BigDecimal(this.value).toString();
            }
            var1_1 = Double.toString(this.value);
            if (var1_1.charAt((var2_2 = var1_1.length()) - 2) == '.' && var1_1.charAt(var2_2 - 1) == '0') {
                if ((var1_1 = var1_1.substring(0, var2_2 - 2)).equals("-0")) {
                    return "0";
                }
                return var1_1;
            }
            var3_3 = var1_1.indexOf(69);
            if (var3_3 >= 0) break block9;
            if (var1_1.equals("Infinity")) {
                return "INF";
            }
            if (!var1_1.equals("-Infinity")) ** GOTO lbl15
            return "-INF";
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.substring(0, --var2_2);
lbl15:
                // 2 sources

                ** while (var1_1.charAt((int)(var2_2 - 1)) == '0' && var1_1.charAt((int)(var2_2 - 2)) != '.')
            }
lbl16:
            // 1 sources

            return var1_1;
        }
        var4_4 = Integer.parseInt(var1_1.substring(var3_3 + 1));
        if (var1_1.charAt(0) == '-') {
            var5_5 = "-";
            var1_1 = var1_1.substring(1);
            --var3_3;
        } else {
            var5_5 = "";
        }
        var6_6 = var3_3 - 2;
        if (var4_4 >= var6_6) {
            return var5_5 + var1_1.substring(0, 1) + var1_1.substring(2, var3_3) + DoubleValue.zeros(var4_4 - var6_6);
        }
        if (var4_4 <= 0) ** GOTO lbl31
        return var5_5 + var1_1.substring(0, 1) + var1_1.substring(2, 2 + var4_4) + "." + var1_1.substring(2 + var4_4, var3_3);
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl31:
            // 2 sources

            ** while (var1_1.charAt((int)(var3_3 - 1)) == '0')
        }
lbl32:
        // 1 sources

        return var5_5 + "0." + DoubleValue.zeros(-1 - var4_4) + var1_1.substring(0, 1) + var1_1.substring(2, var3_3);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    private boolean asBoolean() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public int getItemType() {
        return 105;
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value > -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double d = Math.pow(10.0, n + 1);
        double d2 = Math.abs(this.value * d);
        double d3 = d2 % 10.0;
        d2 = d3 > 5.0 ? (d2 += 10.0 - d3) : (d3 < 5.0 ? (d2 -= d3) : (d2 % 20.0 == 15.0 ? (d2 += 5.0) : (d2 -= 5.0)));
        d2 /= d;
        if (this.value < 0.0) {
            d2 = 0.0 - d2;
        }
        return new DoubleValue(d2);
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value);
    }

    public NumericValue arithmetic(int n, NumericValue numericValue) throws XPathException {
        if (numericValue instanceof DoubleValue) {
            switch (n) {
                case 15: {
                    return new DoubleValue(this.value + ((DoubleValue)numericValue).value);
                }
                case 16: {
                    return new DoubleValue(this.value - ((DoubleValue)numericValue).value);
                }
                case 17: {
                    return new DoubleValue(this.value * ((DoubleValue)numericValue).value);
                }
                case 18: {
                    return new DoubleValue(this.value / ((DoubleValue)numericValue).value);
                }
                case 19: {
                    return new DoubleValue(this.value % ((DoubleValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        return this.arithmetic(n, (DoubleValue)numericValue.convert(105));
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DoubleValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = DoubleValue.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DoubleValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 15;
        }
        if (clazz == Byte.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = DoubleValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 13;
        }
        if (clazz == Character.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = DoubleValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 11;
        }
        if (clazz == Double.TYPE) {
            return 0;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DoubleValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DoubleValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DoubleValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 7;
        }
        if (clazz == Long.TYPE) {
            return 4;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = DoubleValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 5;
        }
        if (clazz == Short.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = DoubleValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 9;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DoubleValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DoubleValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 16;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DoubleValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = DoubleValue.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DoubleValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DoubleValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DoubleValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DoubleValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DoubleValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = DoubleValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DoubleValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = DoubleValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = DoubleValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = DoubleValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        throw new XPathException.Dynamic("Conversion of number to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "number (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

