/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class Closure
extends SequenceValue {
    private Expression expression;
    private XPathContext savedXPathContext;
    private ArrayList reservoir = new ArrayList();
    private int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int MORE_TO_COME = 2;
    private static final int ALL_READ = 3;
    SequenceIterator inputIterator;

    private Closure() {
    }

    public static Value make(Expression expression, XPathContext xPathContext) throws XPathException {
        Object[] objectArray;
        Expression expression2;
        Object[] objectArray2;
        if (expression instanceof TailExpression && (objectArray2 = ((TailExpression)(expression2 = (TailExpression)expression)).getBaseExpression()) instanceof VariableReference && (objectArray2 = ExpressionTool.lazyEvaluate((Expression)objectArray2, xPathContext)) instanceof SequenceExtent) {
            return new SequenceExtent((SequenceExtent)objectArray2, ((TailExpression)expression2).getStart() - 1, ((SequenceExtent)objectArray2).getLength() - ((TailExpression)expression2).getStart() + 1);
        }
        expression2 = new Closure();
        ((Closure)expression2).expression = expression;
        ((Closure)expression2).savedXPathContext = xPathContext.newContext();
        objectArray2 = xPathContext.getLocalVariableFrame();
        if (objectArray2 != null) {
            objectArray = new Object[objectArray2.length];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            ((Closure)expression2).savedXPathContext.setLocalVariableFrame(objectArray);
        }
        if ((objectArray = xPathContext.getCurrentIterator()) != null) {
            Item item = objectArray.current();
            ((Closure)expression2).savedXPathContext.setCurrentIterator(new SingletonIterator(item));
        }
        ((Closure)expression2).state = 0;
        return expression2;
    }

    public int getItemType() {
        return this.expression.getItemType();
    }

    public int getCardinality() {
        return this.expression.getCardinality();
    }

    public int getSpecialProperties() {
        return this.expression.getSpecialProperties();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        if (sequenceIterator.hasNext()) {
            return sequenceIterator.next();
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                return new ProgressiveIterator();
            }
            case 1: 
            case 2: {
                return new ProgressiveIterator();
            }
            case 3: {
                return new ArrayListIterator(this.reservoir);
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public Item itemAt(int n) throws XPathException {
        if (n < this.reservoir.size()) {
            return (Item)this.reservoir.get(n);
        }
        return super.itemAt(n);
    }

    public Object convertToJava(Class clazz) throws XPathException {
        Value value = ExpressionTool.eagerEvaluate(this, null);
        return value.convertToJava(clazz);
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "Closure of expression:");
        this.expression.display(n + 1);
    }

    public final class ProgressiveIterator
    implements SequenceIterator {
        int position = -1;

        public boolean hasNext() throws XPathException {
            if (this.position + 1 < Closure.this.reservoir.size()) {
                return true;
            }
            if (Closure.this.state == 2) {
                return true;
            }
            boolean bl = Closure.this.inputIterator.hasNext();
            Closure.this.state = bl ? 2 : 3;
            return bl;
        }

        public Item next() throws XPathException {
            if (++this.position < Closure.this.reservoir.size()) {
                return (Item)Closure.this.reservoir.get(this.position);
            }
            Item item = Closure.this.inputIterator.next();
            Closure.this.reservoir.add(item);
            Closure.this.state = 1;
            return item;
        }

        public Item current() {
            return (Item)Closure.this.reservoir.get(this.position);
        }

        public int position() {
            return this.position + 1;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ProgressiveIterator();
        }
    }
}

