/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.xpath.XPathException;

abstract class TreeEnumeration
implements AxisIterator {
    protected NodeImpl start;
    protected NodeImpl next;
    protected NodeTest nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;
    protected int last = -1;

    public TreeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.next = nodeImpl;
        this.start = nodeImpl;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl nodeImpl) {
        if (nodeImpl == null || this.nodeTest == null) {
            return true;
        }
        return this.nodeTest.matches(nodeImpl.getItemType(), nodeImpl.getFingerprint(), nodeImpl.getTypeAnnotation());
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step();

    public final boolean hasNext() {
        return this.next != null;
    }

    public final Item next() {
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    public final Item current() {
        return this.current;
    }

    public final int position() {
        return this.position;
    }

    public int getLastPosition() {
        AxisIterator axisIterator;
        if (this.last >= 0) {
            return this.last;
        }
        try {
            axisIterator = (AxisIterator)this.getAnother();
        }
        catch (XPathException xPathException) {
            throw new UnsupportedOperationException("Internal error: Axis iterator must not throw exceptions");
        }
        this.last = 0;
        while (axisIterator.hasNext()) {
            axisIterator.next();
            ++this.last;
        }
        return this.last;
    }
}

