/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.AttributeImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;

final class AttributeEnumeration
extends AxisIteratorImpl {
    private ElementImpl element;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public AttributeEnumeration(NodeImpl nodeImpl, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (nodeImpl.getItemType() == 1) {
            this.element = (ElementImpl)nodeImpl;
            AttributeCollection attributeCollection = this.element.getAttributeList();
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest nameTest = (NameTest)nodeTest;
                this.index = attributeCollection.getIndexByFingerprint(nameTest.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = new AttributeImpl(this.element, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attributeCollection.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() {
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            if (this.index < this.length) {
                this.next = new AttributeImpl(this.element, this.index);
                ++this.index;
                continue;
            }
            this.next = null;
            return;
        } while (!this.nodeTest.matches(this.next.getItemType(), this.next.getFingerprint(), 88));
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.element, this.nodeTest);
    }
}

