/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.xpath.XPathException;

public class Mode
implements Serializable {
    public static final int DEFAULT_MODE = -1;
    public static final int ALL_MODES = -2;
    private Rule[] ruleDict = new Rule[114];
    private String modeName;
    private int sequence = 0;

    public Mode() {
    }

    public Mode(Mode mode) {
        if (mode != null) {
            int n = 0;
            while (n < this.ruleDict.length) {
                if (mode.ruleDict[n] != null) {
                    this.ruleDict[n] = new Rule(mode.ruleDict[n]);
                }
                ++n;
            }
            this.sequence = mode.sequence;
        }
    }

    public void setModeName(String string) {
        this.modeName = string;
    }

    public String getModeName() {
        return this.modeName == null ? "#default" : this.modeName;
    }

    public void addRule(Pattern pattern, Object object, int n, double d) {
        if (pattern instanceof NoNodeTest) {
            return;
        }
        int n2 = pattern.getFingerprint();
        int n3 = pattern.getItemType();
        int n4 = this.getList(n2, n3);
        Rule rule = new Rule(pattern, object, n, d, this.sequence++);
        Rule rule2 = this.ruleDict[n4];
        if (rule2 == null) {
            this.ruleDict[n4] = rule;
            return;
        }
        Rule rule3 = null;
        while (rule2 != null) {
            if (rule2.precedence < n || rule2.precedence == n && rule2.priority <= d) {
                rule.next = rule2;
                if (rule3 == null) {
                    this.ruleDict[n4] = rule;
                    break;
                }
                rule3.next = rule;
                break;
            }
            rule3 = rule2;
            rule2 = rule2.next;
        }
        if (rule2 == null) {
            rule3.next = rule;
            rule.next = null;
        }
    }

    public int getList(int n, int n2) {
        if (n2 == 1) {
            if (n == -1) {
                return 0;
            }
            return 13 + n % 101;
        }
        return n2;
    }

    public Object getRule(NodeInfo nodeInfo, Controller controller) throws TransformerException {
        Rule rule;
        int n = nodeInfo.getFingerprint();
        int n2 = nodeInfo.getItemType();
        int n3 = this.getList(n, n2);
        int n4 = controller.getRecoveryPolicy();
        Rule rule2 = null;
        Rule rule3 = null;
        int n5 = -1;
        double d = Double.NEGATIVE_INFINITY;
        if (n3 != 0) {
            rule = this.ruleDict[n3];
            while (rule != null) {
                if (rule2 != null && (rule.precedence < n5 || rule.precedence == n5 && rule.priority < d)) break;
                if (rule.pattern.matches(nodeInfo, controller)) {
                    if (rule2 != null) {
                        if (rule.precedence != n5 || rule.priority != d) break;
                        this.reportAmbiguity(nodeInfo, rule2, rule, controller);
                        break;
                    }
                    rule2 = rule;
                    n5 = rule.precedence;
                    d = rule.priority;
                    if (n4 == 0) break;
                }
                rule = rule.next;
            }
        }
        rule = this.ruleDict[0];
        while (rule != null) {
            if (rule.precedence < n5 || rule.precedence == n5 && rule.priority < d) break;
            if (rule.pattern.matches(nodeInfo, controller)) {
                if (rule3 != null) {
                    if (rule.precedence != rule3.precedence || rule.priority != rule3.priority) break;
                    this.reportAmbiguity(nodeInfo, rule, rule3, controller);
                    break;
                }
                rule3 = rule;
                if (n4 == 0) break;
            }
            rule = rule.next;
        }
        if (rule2 != null && rule3 == null) {
            return rule2.object;
        }
        if (rule2 == null && rule3 != null) {
            return rule3.object;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.precedence == rule3.precedence && rule2.priority == rule3.priority) {
                Object object;
                Object object2 = object = rule2.sequence > rule3.sequence ? rule2.object : rule3.object;
                if (n4 != 0) {
                    this.reportAmbiguity(nodeInfo, rule2, rule3, controller);
                }
                return object;
            }
            if (rule2.precedence > rule3.precedence || rule2.precedence == rule3.precedence && rule2.priority >= rule3.priority) {
                return rule2.object;
            }
            return rule3.object;
        }
        return null;
    }

    public Object getRule(NodeInfo nodeInfo, int n, int n2, Controller controller) throws XPathException {
        Rule rule;
        int n3 = nodeInfo.getFingerprint();
        int n4 = nodeInfo.getItemType();
        int n5 = this.getList(n3, n4);
        Rule rule2 = null;
        Rule rule3 = null;
        if (n5 != 0) {
            rule = this.ruleDict[n5];
            while (rule != null) {
                if (rule.precedence >= n && rule.precedence <= n2 && rule.pattern.matches(nodeInfo, controller)) {
                    rule2 = rule;
                    break;
                }
                rule = rule.next;
            }
        }
        rule = this.ruleDict[0];
        while (rule != null) {
            if (rule.precedence >= n && rule.precedence <= n2 && rule.pattern.matches(nodeInfo, controller)) {
                rule3 = rule;
                break;
            }
            rule = rule.next;
        }
        if (rule2 != null && rule3 == null) {
            return rule2.object;
        }
        if (rule2 == null && rule3 != null) {
            return rule3.object;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.precedence > rule3.precedence || rule2.precedence == rule3.precedence && rule2.priority >= rule3.priority) {
                return rule2.object;
            }
            return rule3.object;
        }
        return null;
    }

    public Object getNextMatchRule(NodeInfo nodeInfo, Object object, Controller controller) throws TransformerException {
        int n = nodeInfo.getFingerprint();
        int n2 = nodeInfo.getItemType();
        int n3 = this.getList(n, n2);
        int n4 = controller.getRecoveryPolicy();
        int n5 = -1;
        double d = -1.0;
        int n6 = -1;
        Rule rule = this.ruleDict[n3];
        while (rule != null) {
            if (rule.object == object) {
                n5 = rule.precedence;
                d = rule.priority;
                n6 = rule.sequence;
                break;
            }
            rule = rule.next;
        }
        if (rule == null) {
            rule = this.ruleDict[0];
            while (rule != null) {
                if (rule.object == object) {
                    n5 = rule.precedence;
                    d = rule.priority;
                    n6 = rule.sequence;
                    break;
                }
                rule = rule.next;
            }
            if (rule == null) {
                throw new TransformerException("Current template doesn't match current node");
            }
        }
        Rule rule2 = null;
        Rule rule3 = null;
        int n7 = -1;
        double d2 = Double.NEGATIVE_INFINITY;
        if (n3 != 0) {
            rule = this.ruleDict[n3];
            while (rule != null) {
                if (!(rule.precedence > n5 || rule.precedence == n5 && (rule.priority > d || rule.priority == d && rule.sequence >= n6))) {
                    if (rule2 != null && (rule.precedence < n7 || rule.precedence == n7 && rule.priority < d2)) break;
                    if (rule.pattern.matches(nodeInfo, controller)) {
                        if (rule2 != null) {
                            if (rule.precedence != n7 || rule.priority != d2) break;
                            this.reportAmbiguity(nodeInfo, rule2, rule, controller);
                            break;
                        }
                        rule2 = rule;
                        n7 = rule.precedence;
                        d2 = rule.priority;
                        if (n4 == 0) break;
                    }
                }
                rule = rule.next;
            }
        }
        Rule rule4 = this.ruleDict[0];
        while (rule4 != null) {
            if (!(rule4.precedence > n5 || rule4.precedence == n5 && (rule4.priority > d || rule4.priority == d && rule4.sequence >= n6))) {
                if (rule4.precedence < n7 || rule4.precedence == n7 && rule4.priority < d2) break;
                if (rule4.pattern.matches(nodeInfo, controller)) {
                    if (rule3 != null) {
                        if (rule4.precedence != rule3.precedence || rule4.priority != rule3.priority) break;
                        this.reportAmbiguity(nodeInfo, rule4, rule3, controller);
                        break;
                    }
                    rule3 = rule4;
                    if (n4 == 0) break;
                }
            }
            rule4 = rule4.next;
        }
        if (rule2 != null && rule3 == null) {
            return rule2.object;
        }
        if (rule2 == null && rule3 != null) {
            return rule3.object;
        }
        if (rule2 != null && rule3 != null) {
            if (rule2.precedence == rule3.precedence && rule2.priority == rule3.priority) {
                Object object2;
                Object object3 = object2 = rule2.sequence > rule3.sequence ? rule2.object : rule3.object;
                if (n4 != 0) {
                    this.reportAmbiguity(nodeInfo, rule2, rule3, controller);
                }
                return object2;
            }
            if (rule2.precedence > rule3.precedence || rule2.precedence == rule3.precedence && rule2.priority >= rule3.priority) {
                return rule2.object;
            }
            return rule3.object;
        }
        return null;
    }

    private void reportAmbiguity(NodeInfo nodeInfo, Rule rule, Rule rule2, Controller controller) throws TransformerException {
        if (rule.object == rule2.object) {
            return;
        }
        Pattern pattern = rule.pattern;
        Pattern pattern2 = rule2.pattern;
        String string = "node";
        try {
            string = Navigator.getPath(nodeInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        controller.recoverableError("Ambiguous rule match for " + string + "\n" + "Matches both \"" + pattern + "\" on line " + pattern.getLineNumber() + " of " + pattern.getSystemId() + "\nand \"" + pattern2 + "\" on line " + pattern2.getLineNumber() + " of " + pattern2.getSystemId(), null);
    }

    private static class Rule
    implements Serializable {
        public Pattern pattern;
        public Object object;
        public int precedence;
        public double priority;
        public int sequence;
        public Rule next;

        public Rule(Pattern pattern, Object object, int n, double d, int n2) {
            this.pattern = pattern;
            this.object = object;
            this.precedence = n;
            this.priority = d;
            this.next = null;
            this.sequence = n2;
        }

        public Rule(Rule rule) {
            this.pattern = rule.pattern;
            this.object = rule.object;
            this.precedence = rule.precedence;
            this.priority = rule.priority;
            this.sequence = rule.sequence;
            this.next = rule.next == null ? null : new Rule(rule.next);
        }
    }
}

