/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AbstractNode;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.AncestorEnumeration;
import net.sf.saxon.tinytree.AttributeEnumeration;
import net.sf.saxon.tinytree.DescendantEnumeration;
import net.sf.saxon.tinytree.FollowingEnumeration;
import net.sf.saxon.tinytree.NamespaceEnumeration;
import net.sf.saxon.tinytree.PrecedingEnumeration;
import net.sf.saxon.tinytree.PrecedingSiblingEnumeration;
import net.sf.saxon.tinytree.SiblingEnumeration;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import org.w3c.dom.Node;

abstract class TinyNodeImpl
extends AbstractNode {
    protected TinyDocumentImpl document;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;

    TinyNodeImpl() {
    }

    public void setSystemId(String string) {
        short s = this.document.nodeKind[this.nodeNr];
        if (s == 2 || s == 13) {
            this.getParent().setSystemId(string);
        } else {
            this.document.setSystemId(this.nodeNr, string);
        }
    }

    protected void setParentNode(TinyNodeImpl tinyNodeImpl) {
        this.parent = tinyNodeImpl;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return true;
        }
        if (!(nodeInfo instanceof TinyNodeImpl)) {
            return false;
        }
        if (this.document != ((TinyNodeImpl)nodeInfo).document) {
            return false;
        }
        if (this.nodeNr != ((TinyNodeImpl)nodeInfo).nodeNr) {
            return false;
        }
        return this.getItemType() == nodeInfo.getItemType();
    }

    public String getSystemId() {
        return this.document.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    public Node getOriginatingNode() {
        return this;
    }

    public int getLineNumber() {
        return this.document.getLineNumber(this.nodeNr);
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    public final int compareOrder(NodeInfo nodeInfo) {
        long l;
        long l2 = this.getSequenceNumber();
        if (l2 < (l = ((TinyNodeImpl)nodeInfo).getSequenceNumber())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public int getNameCode() {
        return this.document.nameCode[this.nodeNr];
    }

    public String getPrefix() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.document.getNamePool().getPrefix(n);
    }

    public String getURI() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getURI(n);
    }

    public String getDisplayName() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getDisplayName(n);
    }

    public String getLocalName() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getLocalName(n);
    }

    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this.hasChildNodes()) {
                return new SiblingEnumeration(this.document, this, null, true);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        int n = this.getItemType();
        switch (by) {
            case 0: {
                if (n == 9) {
                    return EmptyIterator.getInstance();
                }
                return new AncestorEnumeration(this.document, this, nodeTest, false);
            }
            case 1: {
                if (n == 9) {
                    if (nodeTest.matches(this.getItemType(), this.getFingerprint(), 88)) {
                        return new SingletonIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                return new AncestorEnumeration(this.document, this, nodeTest, true);
            }
            case 2: {
                if (n != 1) {
                    return EmptyIterator.getInstance();
                }
                if (this.document.alpha[this.nodeNr] < 0) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this.document, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new SiblingEnumeration(this.document, this, nodeTest, true);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (n == 9 && nodeTest instanceof NameTest && nodeTest.getItemType() == 1) {
                    return ((TinyDocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.document, this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.document, this, nodeTest, true);
                }
                if (nodeTest.matches(this.getItemType(), this.getFingerprint(), 88)) {
                    return new SingletonIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 6: {
                if (n == 9) {
                    return EmptyIterator.getInstance();
                }
                if (n == 2 || n == 13) {
                    return new FollowingEnumeration(this.document, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                return new FollowingEnumeration(this.document, this, nodeTest, false);
            }
            case 7: {
                if (n == 9 || n == 2 || n == 13) {
                    return EmptyIterator.getInstance();
                }
                return new SiblingEnumeration(this.document, this, nodeTest, false);
            }
            case 8: {
                if (n != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceEnumeration((TinyElementImpl)this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = this.getParent();
                if (nodeInfo == null) {
                    return EmptyIterator.getInstance();
                }
                if (nodeTest.matches(nodeInfo.getItemType(), nodeInfo.getFingerprint(), 88)) {
                    return new SingletonIterator(nodeInfo);
                }
                return EmptyIterator.getInstance();
            }
            case 10: {
                if (n == 9) {
                    return EmptyIterator.getInstance();
                }
                if (n == 2 || n == 13) {
                    return new PrecedingEnumeration(this.document, (TinyNodeImpl)this.getParent(), nodeTest, false);
                }
                return new PrecedingEnumeration(this.document, this, nodeTest, false);
            }
            case 11: {
                if (n == 9 || n == 2 || n == 13) {
                    return EmptyIterator.getInstance();
                }
                return new PrecedingSiblingEnumeration(this.document, this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this.getItemType(), this.getFingerprint(), 88)) {
                    return new SingletonIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 13: {
                if (n == 9) {
                    return EmptyIterator.getInstance();
                }
                if (n == 2 || n == 13) {
                    return new PrecedingEnumeration(this.document, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                return new PrecedingEnumeration(this.document, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public NodeInfo getParent() {
        if (this.nodeNr == this.document.rootNode) {
            this.parent = null;
            return null;
        }
        if (this.parent != null) {
            return this.parent;
        }
        int n = this.document.next[this.nodeNr];
        while (n > this.nodeNr) {
            n = this.document.next[n];
        }
        this.parent = this.document.getNode(n);
        return this.parent;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getAttributeValue(String string, String string2) {
        return null;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.document.getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.document.getDocumentRoot();
    }

    public NamePool getNamePool() {
        return this.document.getNamePool();
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws TransformerException {
    }

    public String generateId() {
        return this.document.generateId() + AbstractNode.NODE_LETTER[this.getItemType()] + this.nodeNr;
    }
}

