/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNamespaceImpl;

final class NamespaceEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl document;
    private TinyElementImpl element;
    private NamePool pool;
    private int owner;
    private int currentElement;
    private int index;
    private ArrayList list = new ArrayList();
    private NodeTest nodeTest;
    private int xmlNamespace;

    protected NamespaceEnumeration(TinyElementImpl tinyElementImpl, NodeTest nodeTest) {
        this.element = tinyElementImpl;
        this.owner = tinyElementImpl.nodeNr;
        this.document = tinyElementImpl.document;
        this.pool = this.document.getNamePool();
        this.currentElement = this.owner;
        this.index = this.document.beta[this.currentElement];
        this.nodeTest = nodeTest;
        this.xmlNamespace = this.pool.allocate("", "", "xml");
        this.advance();
    }

    private void advance() {
        NodeInfo nodeInfo;
        if (this.index == 0) {
            this.index = -1;
            return;
        }
        if (this.index > 0) {
            while (this.index < this.document.numberOfNamespaces && this.document.namespaceParent[this.index] == this.currentElement) {
                int n = this.document.namespaceCode[this.index];
                if (n == 0) {
                    this.list.add(new Short(0));
                } else if (this.matches(n)) {
                    short s = (short)(n >> 16);
                    int n2 = this.list.size();
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        short s2;
                        if ((s2 = ((Short)this.list.get(n3++)).shortValue()) != s) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.list.add(new Short(s));
                        return;
                    }
                }
                ++this.index;
            }
        }
        if ((nodeInfo = this.document.getNode(this.currentElement).getParent()) == null || nodeInfo.getItemType() == 9) {
            this.index = this.nodeTest.matches(13, this.xmlNamespace, 88) ? 0 : -1;
        } else {
            this.currentElement = ((TinyElementImpl)nodeInfo).nodeNr;
            this.index = this.document.beta[this.currentElement];
            this.advance();
        }
    }

    private boolean matches(int n) {
        if (this.nodeTest instanceof NodeKindTest && this.nodeTest.getItemType() == 13) {
            return true;
        }
        int n2 = this.pool.allocate("", "", this.pool.getPrefixFromNamespaceCode(n));
        return this.nodeTest.matches(13, n2, 88);
    }

    public boolean hasNext() {
        return this.index >= 0;
    }

    public Item next() {
        ++this.position;
        this.current = this.document.getNamespaceNode(this.index);
        ((TinyNamespaceImpl)this.current).setParentNode(this.owner);
        this.advance();
        return this.current;
    }

    public SequenceIterator getAnother() {
        return new NamespaceEnumeration(this.element, this.nodeTest);
    }
}

