/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected int variableFingerprint = -1;
    protected Expression select = null;
    protected SequenceType requiredType = null;
    protected String constantText = null;
    protected boolean global;
    protected Procedure procedure = null;
    protected boolean assignable = false;
    protected boolean redundant = false;
    protected boolean requiredParam = false;
    private boolean textonly;

    protected int getReturnedItemType() {
        return 15;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    protected boolean allowsNameAttribute() {
        return true;
    }

    protected boolean allowsTypeAttribute() {
        return true;
    }

    protected boolean allowsValue() {
        return true;
    }

    protected boolean allowsRequired() {
        return false;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public String getVariableName() {
        return this.getAttributeValue("", "name");
    }

    public void setRedundant() {
        this.redundant = true;
    }

    public int getVariableFingerprint() {
        block4: {
            if (this.variableFingerprint != -1) break block4;
            StandardNames standardNames = this.getStandardNames();
            String string = this.getAttributeValue(standardNames.NAME & 0xFFFFF);
            if (string == null) {
                return -1;
            }
            try {
                this.variableFingerprint = this.makeNameCode(string.trim(), false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.variableFingerprint = -1;
            }
            catch (XPathException xPathException) {
                this.variableFingerprint = -1;
            }
        }
        return this.variableFingerprint;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        this.getVariableFingerprint();
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string3 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.AS && this.allowsTypeAttribute()) {
                string4 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.REQUIRED && this.allowsRequired()) {
                string5 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.SAXON_ASSIGNABLE && this instanceof XSLVariableDeclaration) {
                string2 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string3 == null) {
            if (this.allowsNameAttribute()) {
                this.reportAbsence("name");
            }
        } else if (!Name.isQName(string3)) {
            this.compileError("Variable name must be a valid QName");
        }
        if (string != null) {
            if (!this.allowsValue()) {
                this.compileError("Function parameters cannot have a default value");
            }
            this.select = this.makeExpression(string);
        }
        if (string2 != null && string2.equals("yes")) {
            this.assignable = true;
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.requiredParam = true;
            } else if (string5.equals("no")) {
                this.requiredParam = false;
            } else {
                this.compileError("The attribute 'required' must be set to 'yes' or 'no'");
            }
        }
        if (string4 != null) {
            this.requiredType = this.makeSequenceType(string4);
        }
    }

    public void validate() throws TransformerConfigurationException {
        block14: {
            Object object;
            this.global = this.getParentNode() instanceof XSLStyleSheet;
            if (this.global) {
                this.procedure = new Procedure();
            }
            if (this.select != null && this.hasChildNodes()) {
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty");
            }
            try {
                object = new RoleLocator(3, this.getVariableName(), 0);
                if (this.requiredType != null && this.select != null) {
                    this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, (RoleLocator)object);
                }
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            if (this.select == null && this.allowsValue()) {
                this.textonly = true;
                object = this.iterateAxis((byte)3);
                if (!object.hasNext()) {
                    if (this.requiredType == null) {
                        this.select = StringValue.EMPTY_STRING;
                    } else {
                        try {
                            this.select = StringValue.EMPTY_STRING.convert(this.requiredType.getPrimaryType());
                        }
                        catch (XPathException xPathException) {
                            if (this instanceof XSLParam) {
                                this.select = StringValue.EMPTY_STRING;
                                break block14;
                            }
                            this.compileError(xPathException);
                        }
                    }
                } else {
                    NodeInfo nodeInfo = (NodeInfo)object.next();
                    if (!object.hasNext() && nodeInfo.getItemType() == 3) {
                        this.constantText = nodeInfo.getStringValue();
                    }
                    this.textonly = this.getCommonChildItemType() == 3;
                }
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    protected void initializeInstruction(GeneralVariable generalVariable) throws TransformerConfigurationException {
        generalVariable.init(this.select, this.requiredType, this.variableFingerprint);
        generalVariable.setGlobal(this.global);
        generalVariable.setAssignable(this.assignable);
        generalVariable.setRequiredParam(this.requiredParam);
        generalVariable.setContainsLocals(this.global && this.procedure.getNumberOfVariables() > 0);
        if (this.hasChildNodes() && this.requiredType == null) {
            DocumentInstr documentInstr = new DocumentInstr(this.textonly, this.constantText, this.getBaseURI());
            this.compileChildren(documentInstr);
            generalVariable.setSelect(documentInstr);
        } else {
            this.compileChildren(generalVariable);
        }
    }

    public Procedure getProcedure() {
        return this.procedure;
    }
}

