/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Element;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validationAction = 3;
    private int annotation = 94;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.NAMESPACE) {
                string2 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.VALIDATION) {
                string3 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.TYPE) {
                string4 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.USE_ATTRIBUTE_SETS) {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(string);
            if (this.elementName instanceof StringValue && !Name.isQName(string)) {
                this.compileError("Element name is not a valid QName");
                this.elementName = new StringValue("saxon-error-element");
            }
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction == 1) {
                this.compileError("validation=strict is not yet supported");
            }
            if (this.validationAction == 2) {
                this.compileError("validation=lax is not yet supported");
            }
            if (this.validationAction == 3) {
                this.compileError("validation=preserve is not yet supported");
            }
            if (this.validationAction == 4) {
                this.compileError("validation=strip is not yet supported");
            }
            if (this.validationAction == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            this.annotation = this.getTypeAnnotationCode(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
    }

    public Instruction compile() throws TransformerConfigurationException {
        Object object;
        NamespaceContext namespaceContext = null;
        if (this.elementName instanceof StringValue) {
            String[] stringArray;
            object = ((StringValue)this.elementName).getStringValue();
            try {
                stringArray = Name.getQNameParts((String)object);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid element name: " + (String)object);
                return null;
            }
            if (this.namespace == null) {
                try {
                    this.namespace = new StringValue(this.getURIForPrefix(stringArray[0], true));
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                    return null;
                }
            }
        } else if (this.namespace == null) {
            namespaceContext = this.makeNamespaceContext();
        }
        try {
            object = new Element(this.elementName, this.namespace, namespaceContext, this.attributeSets, this.annotation);
            this.compileChildren((Instruction)object);
            return object;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
            return null;
        }
    }
}

