/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Copy;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        Object var4_4 = null;
        Object var5_5 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.USE_ATTRIBUTE_SETS) {
                this.use = attributeCollection.getValue(n);
            } else if (n3 == standardNames.COPY_NAMESPACES) {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.copyNamespaces = true;
        } else if (string.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        Copy copy = new Copy(this.attributeSets, this.copyNamespaces);
        this.compileChildren(copy);
        return copy;
    }
}

