/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.BooleanValue;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    public boolean isInstruction() {
        return true;
    }

    protected int getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            this.checkUnknownAttribute(n2);
            ++n;
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (nodeInfo instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose");
                    continue;
                }
                this.otherwise = (StyleElement)nodeInfo;
                continue;
            }
            if (nodeInfo.getItemType() == 3 && Navigator.isWhite(nodeInfo.getStringValue())) continue;
            this.compileError("Only xsl:when and xsl:otherwise are allowed here");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when");
        }
    }

    public void markTailCalls() {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).markTailCalls();
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        Object object;
        Expression[] expressionArray;
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        int n = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] expressionArray2 = new Expression[n];
        Instruction[] instructionArray = new Instruction[n];
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            expressionArray = (Expression[])axisIterator.next();
            if (expressionArray instanceof XSLWhen) {
                expressionArray2[n2] = ((XSLWhen)expressionArray).getCondition();
                object = new Block();
                ((XSLWhen)expressionArray).compileChildren((Instruction)object);
                instructionArray[n2] = object;
                ((Instruction)object).setSourceLocation(xSLStyleSheet.putModuleNumber(expressionArray.getSystemId()), expressionArray.getLineNumber());
                if (expressionArray2[n2] instanceof BooleanValue) {
                    if (((BooleanValue)expressionArray2[n2]).getValue()) {
                        n = n2 + 1;
                        break;
                    }
                    --n2;
                    --n;
                }
                ++n2;
                continue;
            }
            if (expressionArray instanceof XSLOtherwise) {
                expressionArray2[n2] = BooleanValue.TRUE;
                object = new Block();
                ((XSLOtherwise)expressionArray).compileChildren((Instruction)object);
                instructionArray[n2++] = object;
                ((Instruction)object).setSourceLocation(xSLStyleSheet.putModuleNumber(expressionArray.getSystemId()), expressionArray.getLineNumber());
                continue;
            }
            new AssertionError((Object)"Expected xsl:when or xsl:otherwise");
        }
        if (expressionArray2.length != n) {
            expressionArray = new Expression[n];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            object = new Instruction[n];
            System.arraycopy(instructionArray, 0, object, 0, n);
            expressionArray2 = expressionArray;
            instructionArray = object;
        }
        return new Choose(expressionArray2, instructionArray);
    }
}

