/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.CallTemplate;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLCallTemplate
extends StyleElement {
    private int calledTemplateFingerprint = -1;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private String calledTemplateName = null;

    public boolean isInstruction() {
        return true;
    }

    protected int getReturnedItemType() {
        if (this.template == null) {
            return 88;
        }
        return this.template.getReturnedItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            int n3 = n & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.SAXON_ALLOW_AVT) {
                string = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string2 == null) {
            this.reportAbsence("name");
            return;
        }
        int n4 = n = string != null && string.equals("yes") ? 1 : 0;
        if (n != 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(string2);
        } else {
            this.calledTemplateName = string2;
            try {
                this.calledTemplateFingerprint = this.makeNameCode(string2, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.calledTemplateExpression == null) {
            this.template = this.findTemplate(this.calledTemplateFingerprint);
        }
        this.calledTemplateExpression = this.typeCheck("name", this.calledTemplateExpression);
    }

    private XSLTemplate findTemplate(int n) throws TransformerConfigurationException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            XSLTemplate xSLTemplate;
            if (list.get(n2) instanceof XSLTemplate && (xSLTemplate = (XSLTemplate)list.get(n2)).getTemplateFingerprint() == n) {
                return xSLTemplate;
            }
            --n2;
        }
        this.compileError("No template exists named " + this.calledTemplateName);
        return null;
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Instruction compile() throws TransformerConfigurationException {
        Template template = null;
        NamespaceContext namespaceContext = null;
        if (this.calledTemplateExpression == null) {
            if (this.template == null) {
                return null;
            }
            template = this.template.getCompiledTemplate();
        } else {
            this.getPrincipalStyleSheet().setRequireRuntimeTemplateMap(true);
            namespaceContext = this.makeNamespaceContext();
        }
        return new CallTemplate(template, this.getWithParamInstructions(), this.useTailRecursion, this.calledTemplateExpression, namespaceContext);
    }
}

