/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Loader;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.ExtensionElementFactory;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.SAXONAssign;
import net.sf.saxon.style.SAXONCollation;
import net.sf.saxon.style.SAXONDoctype;
import net.sf.saxon.style.SAXONEntityRef;
import net.sf.saxon.style.SAXONScript;
import net.sf.saxon.style.SAXONWhile;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSortKey;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeFactory;
import org.xml.sax.Locator;

public class StyleNodeFactory
implements NodeFactory {
    HashMap userStyles = new HashMap();
    NamePool namePool;
    StandardNames sn;
    boolean allowExtensions;
    static /* synthetic */ Class class$net$sf$saxon$style$LiteralResultElement;
    static /* synthetic */ Class class$net$sf$saxon$style$AbsentExtensionElement;

    public StyleNodeFactory(NamePool namePool, StandardNames standardNames, boolean bl) {
        this.namePool = namePool;
        this.sn = standardNames;
        this.allowExtensions = bl;
    }

    public StandardNames getStandardNames() {
        return this.sn;
    }

    public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollection attributeCollection, int[] nArray, int n2, Locator locator, int n3) {
        Object object;
        Class clazz;
        boolean bl = nodeInfo instanceof XSLStyleSheet;
        String string = null;
        int n4 = -1;
        if (locator != null) {
            string = locator.getSystemId();
            n4 = locator.getLineNumber();
        }
        if (nodeInfo instanceof DataElement) {
            DataElement dataElement = new DataElement();
            dataElement.setNamespaceDeclarations(nArray, n2);
            dataElement.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
            return dataElement;
        }
        int n5 = n & 0xFFFFF;
        StyleElement styleElement = this.makeXSLElement(n5);
        if (styleElement != null) {
            try {
                styleElement.setNamespaceDeclarations(nArray, n2);
                styleElement.setLineNumber(n4);
                styleElement.initialise(n, attributeCollection, nodeInfo, string, -1, n3);
                styleElement.processExtensionElementAttribute(this.sn.EXTENSION_ELEMENT_PREFIXES);
                styleElement.processExcludedNamespaces(this.sn.EXCLUDE_RESULT_PREFIXES);
                styleElement.processVersionAttribute(this.sn.VERSION);
                styleElement.processDefaultXPathNamespaceAttribute(this.sn.XPATH_DEFAULT_NAMESPACE);
            }
            catch (TransformerException transformerException) {
                styleElement.setValidationError(transformerException, 1);
            }
            return styleElement;
        }
        short s = this.namePool.getURICode(n);
        String string2 = this.namePool.getLocalName(n);
        Class clazz2 = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        StyleElement styleElement2 = null;
        boolean bl2 = false;
        if (s == 3) {
            styleElement2 = this.makeSaxonElement(n5);
            if (styleElement2 != null) {
                clazz2 = styleElement2.getClass();
                bl2 = true;
            }
        } else if (bl && s != 0) {
            DataElement dataElement = new DataElement();
            dataElement.setNamespaceDeclarations(nArray, n2);
            dataElement.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
            return dataElement;
        }
        if (styleElement2 == null) {
            styleElement2 = new LiteralResultElement();
        }
        styleElement2.setNamespaceDeclarations(nArray, n2);
        try {
            styleElement2.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
            styleElement2.setLineNumber(n4);
            styleElement2.processExtensionElementAttribute(this.sn.XSL_EXTENSION_ELEMENT_PREFIXES);
            styleElement2.processExcludedNamespaces(this.sn.XSL_EXCLUDE_RESULT_PREFIXES);
            styleElement2.processVersionAttribute(this.sn.XSL_VERSION);
            styleElement2.processDefaultXPathNamespaceAttribute(this.sn.XSL_XPATH_DEFAULT_NAMESPACE);
        }
        catch (TransformerException transformerException) {
            styleElement2.setValidationError(transformerException, 2);
        }
        TransformerConfigurationException transformerConfigurationException = null;
        Class clazz3 = clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        if (s == 2) {
            transformerConfigurationException = new TransformerConfigurationException("Unknown XSLT element: " + string2);
            clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
            styleElement2.setValidationError(transformerConfigurationException, 2);
        } else if (s == 3 || s == 4) {
            if (bl || styleElement2.isExtensionNamespace(s)) {
                if (bl2) {
                    clazz = clazz2;
                } else {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown Saxon extension element: " + string2);
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            } else {
                clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
            }
        } else if (styleElement2.isExtensionNamespace(s) && !bl) {
            object = new Integer(n & 0xFFFFF);
            clazz = (Class)this.userStyles.get(object);
            if (clazz == null) {
                if (!this.allowExtensions) {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Extension elements are disabled");
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                } else {
                    ExtensionElementFactory extensionElementFactory = this.getFactory(s);
                    if (extensionElementFactory != null && (clazz = extensionElementFactory.getExtensionClass(string2)) != null) {
                        this.userStyles.put(object, clazz);
                    }
                }
                if (clazz == null) {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    transformerConfigurationException = new TransformerConfigurationException("Unknown extension element", styleElement2);
                    styleElement2.setValidationError(transformerConfigurationException, 3);
                }
            }
        } else {
            Class clazz4 = clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        }
        if (!clazz.equals(clazz2)) {
            try {
                object = (StyleElement)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TransformerFactoryConfigurationError(instantiationException, "Failed to create instance of " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TransformerFactoryConfigurationError(illegalAccessException, "Failed to access class " + clazz.getName());
            }
            ((StyleElement)object).substituteFor(styleElement2);
        } else {
            object = styleElement2;
        }
        return object;
    }

    private StyleElement makeXSLElement(int n) {
        StyleElement styleElement = null;
        if (n == this.sn.XSL_ANALYZE_STRING) {
            styleElement = new XSLAnalyzeString();
        } else if (n == this.sn.XSL_APPLY_IMPORTS) {
            styleElement = new XSLApplyImports();
        } else if (n == this.sn.XSL_APPLY_TEMPLATES) {
            styleElement = new XSLApplyTemplates();
        } else if (n == this.sn.XSL_ATTRIBUTE) {
            styleElement = new XSLAttribute();
        } else if (n == this.sn.XSL_ATTRIBUTE_SET) {
            styleElement = new XSLAttributeSet();
        } else if (n == this.sn.XSL_CALL_TEMPLATE) {
            styleElement = new XSLCallTemplate();
        } else if (n == this.sn.XSL_CHARACTER_MAP) {
            styleElement = new XSLCharacterMap();
        } else if (n == this.sn.XSL_CHOOSE) {
            styleElement = new XSLChoose();
        } else if (n == this.sn.XSL_COMMENT) {
            styleElement = new XSLComment();
        } else if (n == this.sn.XSL_COPY) {
            styleElement = new XSLCopy();
        } else if (n == this.sn.XSL_COPY_OF) {
            styleElement = new XSLCopyOf();
        } else if (n == this.sn.XSL_DECIMAL_FORMAT) {
            styleElement = new XSLDecimalFormat();
        } else if (n == this.sn.XSL_ELEMENT) {
            styleElement = new XSLElement();
        } else if (n == this.sn.XSL_FALLBACK) {
            styleElement = new XSLFallback();
        } else if (n == this.sn.XSL_FOR_EACH) {
            styleElement = new XSLForEach();
        } else if (n == this.sn.XSL_FOR_EACH_GROUP) {
            styleElement = new XSLForEachGroup();
        } else if (n == this.sn.XSL_FUNCTION) {
            styleElement = new XSLFunction();
        } else if (n == this.sn.XSL_IF) {
            styleElement = new XSLIf();
        } else if (n == this.sn.XSL_IMPORT) {
            styleElement = new XSLImport();
        } else if (n == this.sn.XSL_INCLUDE) {
            styleElement = new XSLInclude();
        } else if (n == this.sn.XSL_KEY) {
            styleElement = new XSLKey();
        } else if (n == this.sn.XSL_MATCHING_SUBSTRING) {
            styleElement = new XSLMatchingSubstring();
        } else if (n == this.sn.XSL_MESSAGE) {
            styleElement = new XSLMessage();
        } else if (n == this.sn.XSL_NEXT_MATCH) {
            styleElement = new XSLNextMatch();
        } else if (n == this.sn.XSL_NON_MATCHING_SUBSTRING) {
            styleElement = new XSLMatchingSubstring();
        } else if (n == this.sn.XSL_NUMBER) {
            styleElement = new XSLNumber();
        } else if (n == this.sn.XSL_NAMESPACE) {
            styleElement = new XSLNamespace();
        } else if (n == this.sn.XSL_NAMESPACE_ALIAS) {
            styleElement = new XSLNamespaceAlias();
        } else if (n == this.sn.XSL_OTHERWISE) {
            styleElement = new XSLOtherwise();
        } else if (n == this.sn.XSL_OUTPUT) {
            styleElement = new XSLOutput();
        } else if (n == this.sn.XSL_OUTPUT_CHARACTER) {
            styleElement = new XSLOutputCharacter();
        } else if (n == this.sn.XSL_PARAM) {
            styleElement = new XSLParam();
        } else if (n == this.sn.XSL_PRESERVE_SPACE) {
            styleElement = new XSLPreserveSpace();
        } else if (n == this.sn.XSL_PROCESSING_INSTRUCTION) {
            styleElement = new XSLProcessingInstruction();
        } else if (n == this.sn.XSL_RESULT_DOCUMENT) {
            styleElement = new XSLResultDocument();
        } else if (n == this.sn.XSL_SEQUENCE) {
            styleElement = new XSLSequence();
        } else if (n == this.sn.XSL_SORT) {
            styleElement = new XSLSort();
        } else if (n == this.sn.XSL_SORT_KEY) {
            styleElement = new XSLSortKey();
        } else if (n == this.sn.XSL_STRIP_SPACE) {
            styleElement = new XSLPreserveSpace();
        } else if (n == this.sn.XSL_STYLESHEET) {
            styleElement = new XSLStyleSheet();
        } else if (n == this.sn.XSL_TEMPLATE) {
            styleElement = new XSLTemplate();
        } else if (n == this.sn.XSL_TEXT) {
            styleElement = new XSLText();
        } else if (n == this.sn.XSL_TRANSFORM) {
            styleElement = new XSLStyleSheet();
        } else if (n == this.sn.XSL_VALUE_OF) {
            styleElement = new XSLValueOf();
        } else if (n == this.sn.XSL_VARIABLE) {
            styleElement = new XSLVariable();
        } else if (n == this.sn.XSL_WITH_PARAM) {
            styleElement = new XSLWithParam();
        } else if (n == this.sn.XSL_WHEN) {
            styleElement = new XSLWhen();
        }
        return styleElement;
    }

    private StyleElement makeSaxonElement(int n) {
        StyleElement styleElement = null;
        if (n == this.sn.SAXON_ASSIGN) {
            styleElement = new SAXONAssign();
        } else if (n == this.sn.SAXON_ENTITY_REF) {
            styleElement = new SAXONEntityRef();
        } else if (n == this.sn.SAXON_COLLATION) {
            styleElement = new SAXONCollation();
        } else if (n == this.sn.SAXON_DOCTYPE) {
            styleElement = new SAXONDoctype();
        } else if (n == this.sn.SAXON_SCRIPT) {
            styleElement = new SAXONScript();
        } else if (n == this.sn.SAXON_WHILE) {
            styleElement = new SAXONWhile();
        }
        return styleElement;
    }

    private ExtensionElementFactory getFactory(short s) {
        ExtensionElementFactory extensionElementFactory;
        String string = this.namePool.getURIFromNamespaceCode(s);
        int n = string.lastIndexOf(47);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        try {
            extensionElementFactory = (ExtensionElementFactory)Loader.getInstance(string2);
        }
        catch (Exception exception) {
            return null;
        }
        return extensionElementFactory;
    }

    public boolean isElementAvailable(String string, String string2) {
        StyleElement styleElement;
        int n = this.namePool.getFingerprint(string, string2);
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeXSLElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (string.equals("http://saxon.sf.net/")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeSaxonElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (!this.allowExtensions) {
            return false;
        }
        short s = this.namePool.getCodeForURI(string);
        ExtensionElementFactory extensionElementFactory = this.getFactory(s);
        if (extensionElementFactory == null) {
            return false;
        }
        Class clazz = extensionElementFactory.getExtensionClass(string2);
        return clazz != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

