/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.FunctionSignature;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.query.FunctionDefinition;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class StaticQueryContext
implements StaticContext {
    private Configuration config;
    private NamePool namePool;
    private HashMap namespaces = new HashMap();
    private HashMap collations = new HashMap();
    private HashMap variables = new HashMap();
    private HashMap functions = new HashMap();
    private List unboundFunctionCalls = new ArrayList();
    private String defaultCollationName = null;
    private String defaultFunctionNamespace = "http://www.w3.org/2003/05/xpath-functions";
    private short defaultElementNamespace = 0;
    private String baseURI = "";
    private int localStackFrameSize = 0;

    public StaticQueryContext() {
        this(NamePool.getDefaultNamePool());
    }

    public StaticQueryContext(NamePool namePool) {
        this.namePool = namePool;
        this.clearNamespaces();
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("fn", "http://www.w3.org/2003/05/xpath-functions");
        this.declareNamespace("xdt", "http://www.w3.org/2003/05/xpath-datatypes");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("", "");
    }

    public NamespaceContext getNamespaceContext() {
        int[] nArray = new int[this.namespaces.size()];
        int n = 0;
        Iterator iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.namespaces.get(string);
            nArray[n++] = this.namePool.getNamespaceCode(string, string2);
        }
        return new NamespaceContext(nArray);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    protected void setDefaultElementNamespace(String string) {
        int n = this.namePool.allocateNamespaceCode("", string);
        this.defaultElementNamespace = (short)(n & 0xFFFF);
        this.declareNamespace("", string);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.collations.put(string, comparator);
    }

    public void declareDefaultCollation(String string) throws XPathException {
        Object v = this.collations.get(string);
        if (v == null) {
            throw new XPathException.Static("Collation " + string + " is not recognized");
        }
    }

    public Comparator getCollation(String string) {
        Comparator comparator = (Comparator)this.collations.get(string);
        if (comparator != null) {
            return comparator;
        }
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public HashMap getAllCollations() {
        return new HashMap(this.collations);
    }

    public void declareVariable(VariableDeclaration variableDeclaration) throws XPathException {
        Integer n = new Integer(variableDeclaration.getVariableFingerprint());
        if (this.variables.get(n) != null) {
            throw new XPathException.Static("Duplicate definition of global variable " + variableDeclaration.getVariableName());
        }
        this.variables.put(n, variableDeclaration);
    }

    public void fixupGlobalVariables() throws XPathException {
        int n = 1;
        Iterator iterator = this.variables.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)v;
            globalVariableDefinition.compile(this, n++);
        }
    }

    public int getNumberOfGlobalVariables() {
        return this.variables.size();
    }

    public void allocateLocalSlots(int n) {
        if (n > this.localStackFrameSize) {
            this.localStackFrameSize = n;
        }
    }

    public int getNumberOfLocalVariables() {
        return this.localStackFrameSize;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null) {
            throw new XPathException.Static("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public VariableDeclaration bindVariable(int n) throws XPathException {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(new Integer(n));
        if (variableDeclaration == null) {
            throw new XPathException.Static("Undeclared variable in query");
        }
        return variableDeclaration;
    }

    public void declareFunction(FunctionDefinition functionDefinition) throws XPathException {
        Integer n = new Integer(functionDefinition.getFunctionFingerprint());
        if (this.functions.get(n) != null) {
            throw new XPathException.Static("Duplicate definition of function " + this.namePool.getDisplayName(functionDefinition.getFunctionFingerprint()));
        }
        this.functions.put(n, functionDefinition);
    }

    public Expression bindFunction(String string, Expression[] expressionArray) throws XPathException {
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid function name. " + qNameException.getMessage());
        }
        String string2 = stringArray[0] == null || stringArray[0].equals("") ? this.getDefaultFunctionNamespace() : this.getURIForPrefix(stringArray[0]);
        if (string2.equals("http://www.w3.org/2003/05/xpath-functions")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction(stringArray[1]);
            if (functionCall == null) {
                throw new XPathException.Static("Unknown system function: " + string);
            }
            if (functionCall instanceof XSLTFunction) {
                throw new XPathException.Static("Function " + string + " is available only in XSLT");
            }
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        int n = this.namePool.allocate(stringArray[0], string2, stringArray[1]);
        int n2 = n & 0xFFFFF;
        if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string2.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            if (expressionArray.length != 1) {
                throw new XPathException.Static("A constructor function must have exactly one argument");
            }
            SequenceType sequenceType = new SequenceType(Type.getNamedType(string2, stringArray[1]), 88, 512);
            return new CastExpression(expressionArray[0], sequenceType);
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "evaluate")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:evaluate");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "expression")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:expression");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "parse")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:parse");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n2 == this.namePool.getFingerprint("http://saxon.sf.net/", "serialize")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:serialize");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        Class clazz = null;
        try {
            clazz = this.getExternalJavaClass(string2);
        }
        catch (Exception exception) {
            throw new XPathException.Static("Cannot load external Java class", exception);
        }
        if (clazz != null) {
            if (!this.config.isAllowExternalFunctions()) {
                throw new XPathException.Static("External functions are disabled");
            }
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setDebug(this.config.isTraceExternalFunctions());
            functionProxy.setArguments(expressionArray);
            functionProxy.setFunctionName(clazz, stringArray[1]);
            return functionProxy;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFingerprint(n2);
        userFunctionCall.setArguments(expressionArray);
        this.unboundFunctionCalls.add(userFunctionCall);
        return userFunctionCall;
    }

    protected void bindUnboundFunctionCalls() throws XPathException {
        Iterator iterator = this.unboundFunctionCalls.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            int n = userFunctionCall.getFingerprint();
            int n2 = userFunctionCall.getNumberOfArguments();
            Integer n3 = new Integer(n);
            FunctionDefinition functionDefinition = (FunctionDefinition)this.functions.get(n3);
            if (functionDefinition != null) {
                userFunctionCall.setStaticType(functionDefinition.getResultType());
                functionDefinition.register(userFunctionCall);
                continue;
            }
            throw new XPathException.Static("Function " + this.namePool.getDisplayName(n) + " has not been declared", ExpressionTool.getLocator(userFunctionCall));
        }
    }

    protected void fixupGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            FunctionDefinition functionDefinition = (FunctionDefinition)iterator.next();
            functionDefinition.compile(this);
        }
    }

    public void explainGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            FunctionDefinition functionDefinition = (FunctionDefinition)iterator.next();
            functionDefinition.explain();
        }
    }

    public FunctionSignature getFunctionSignature(int n, int n2) {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            FunctionDefinition functionDefinition = (FunctionDefinition)iterator.next();
            if (functionDefinition.getFunctionFingerprint() != n || functionDefinition.getNumberOfArguments() != n2) continue;
            return functionDefinition;
        }
        return null;
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = FunctionProxy.getVendorExtensionClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5));
            }
        }
        catch (TransformerException transformerException) {
            return null;
        }
        return null;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }
}

