/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.xpath.XPathException;

public class QueryProcessor {
    private StaticQueryContext staticContext;
    private Configuration config;

    public QueryProcessor(Configuration configuration, StaticQueryContext staticQueryContext) {
        this.config = configuration;
        configuration.setHostLanguage(11);
        this.staticContext = staticQueryContext;
        staticQueryContext.setConfiguration(configuration);
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        if (source == null) {
            throw new NullPointerException("Source cannot be null");
        }
        boolean bl = this.config.isStripsAllWhiteSpace();
        if (source instanceof DocumentInfo && !bl) {
            return (DocumentInfo)source;
        }
        Builder builder = this.config.getTreeModel() == 1 ? new TinyBuilder() : new TreeBuilder();
        NamePool namePool = NamePool.getDefaultNamePool();
        builder.setNamePool(namePool);
        Receiver receiver = builder;
        if (bl) {
            AllElementStripper allElementStripper = AllElementStripper.getInstance();
            allElementStripper.setUnderlyingReceiver(builder);
            receiver = allElementStripper;
        }
        try {
            new Sender(this.config).send(source, receiver, namePool, false);
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
        return builder.getCurrentDocument();
    }

    public void setStaticContext(StaticQueryContext staticQueryContext) {
        this.staticContext = staticQueryContext;
    }

    public StaticQueryContext getStaticContext() {
        return this.staticContext;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XQueryExpression compileQuery(String string) throws XPathException {
        QueryParser queryParser = new QueryParser();
        Expression expression = queryParser.parseQuery(string, this.staticContext);
        XQueryExpression xQueryExpression = new XQueryExpression(expression, this.staticContext, this.config);
        return xQueryExpression;
    }

    public XQueryExpression compileQuery(Reader reader) throws XPathException, IOException {
        int n;
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer.toString());
    }
}

