/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.instruct.FunctionSignature;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

class FunctionDefinition
implements FunctionSignature {
    int fingerprint;
    String displayName;
    List arguments;
    SequenceType resultType;
    Expression body;
    List references = new ArrayList();
    int lineNumber;

    FunctionDefinition() {
    }

    public int getFunctionFingerprint() {
        return this.fingerprint;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.arguments.size()];
        int n = 0;
        while (n < this.arguments.size()) {
            sequenceTypeArray[n] = ((RangeVariableDeclaration)this.arguments.get(n)).getRequiredType();
            ++n;
        }
        return sequenceTypeArray;
    }

    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    public void register(UserFunctionCall userFunctionCall) {
        this.references.add(userFunctionCall);
    }

    public UserFunction compile(StaticQueryContext staticQueryContext) throws XPathException {
        Object object;
        Iterator iterator = this.arguments.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (RangeVariableDeclaration)iterator.next();
            UserFunctionParameter userFunctionParameter = new UserFunctionParameter();
            userFunctionParameter.setSlotNumber(n++);
            userFunctionParameter.setVariableName(((RangeVariableDeclaration)object).getVariableName());
            userFunctionParameter.setRequiredType(((RangeVariableDeclaration)object).getRequiredType());
            ((RangeVariableDeclaration)object).fixupReferences(userFunctionParameter);
        }
        this.body = this.body.simplify().analyze(staticQueryContext);
        object = new RoleLocator(5, this.displayName, 0);
        this.body = TypeChecker.staticTypeCheck(this.body, this.resultType, false, (RoleLocator)object);
        int n2 = FunctionDefinition.allocateSlots(this.body, n);
        staticQueryContext.allocateLocalSlots(n2);
        UserFunction userFunction = new UserFunction(this.body);
        userFunction.setFunctionName(this.displayName);
        userFunction.setLineNumber(this.lineNumber);
        iterator = this.references.iterator();
        while (iterator.hasNext()) {
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            userFunctionCall.setFunction(this, userFunction);
        }
        ExpressionTool.markTailFunctionCalls(this.body);
        return userFunction;
    }

    protected static int allocateSlots(Expression expression, int n) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n++);
        }
        Expression[] expressionArray = expression.getSubExpressions();
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n = FunctionDefinition.allocateSlots(expressionArray[n2], n);
            ++n2;
        }
        return n;
    }

    public void explain() {
        System.err.println("define function " + this.displayName + " {");
        this.body.display(1);
        System.err.println("}");
    }
}

