/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.xpath.XPathException;

public final class Navigator {
    public static final boolean isWhite(CharSequence charSequence) {
        int n = 0;
        while (n < charSequence.length()) {
            if (charSequence.charAt(n++) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String getPath(NodeInfo nodeInfo) {
        NodeInfo nodeInfo2 = nodeInfo.getParent();
        if (nodeInfo2 == null) {
            return "/";
        }
        switch (nodeInfo.getItemType()) {
            case 9: {
                return "/";
            }
            case 1: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/" + nodeInfo.getDisplayName() + "[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 2: {
                return Navigator.getPath(nodeInfo2) + "/@" + nodeInfo.getDisplayName();
            }
            case 3: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/text()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 8: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/comment()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 7: {
                String string = Navigator.getPath(nodeInfo2);
                return (string.equals("/") ? "" : string) + "/processing-instruction()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 13: {
                return Navigator.getPath(nodeInfo2) + "/namespace::" + nodeInfo.getLocalName();
            }
        }
        return "";
    }

    public static int getNumberSimple(NodeInfo nodeInfo, Controller controller) throws XPathException {
        int n = nodeInfo.getFingerprint();
        NodeTest nodeTest = n == -1 ? new NodeKindTest(nodeInfo.getItemType()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n2 = 1;
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
            int n3 = controller.getRememberedNumber(nodeInfo2);
            if (n3 > 0) {
                controller.setRememberedNumber(nodeInfo, n3 += n2);
                return n3;
            }
            ++n2;
        }
        controller.setRememberedNumber(nodeInfo, n2);
        return n2;
    }

    private static int getNumberSimple(NodeInfo nodeInfo) {
        int n = nodeInfo.getFingerprint();
        NodeTest nodeTest = n == -1 ? new NodeKindTest(nodeInfo.getItemType()) : new NameTest(nodeInfo);
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)11, nodeTest);
        int n2 = 1;
        while (axisIterator.hasNext()) {
            axisIterator.next();
            ++n2;
        }
        return n2;
    }

    public static int getNumberSingle(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller) throws XPathException {
        if (pattern == null && pattern2 == null) {
            return Navigator.getNumberSimple(nodeInfo, controller);
        }
        boolean bl = false;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeKindTest(nodeInfo.getItemType()) : new NameTest(nodeInfo);
            bl = true;
        }
        NodeInfo nodeInfo2 = nodeInfo;
        while (!bl && !pattern.matches(nodeInfo2, controller)) {
            if ((nodeInfo2 = nodeInfo2.getParent()) == null) {
                return 0;
            }
            if (pattern2 == null || !pattern2.matches(nodeInfo2, controller)) continue;
            return 0;
        }
        AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)11, pattern.getNodeTest());
        boolean bl2 = pattern instanceof NodeTest;
        int n = 1;
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo3 = (NodeInfo)axisIterator.next();
            if (!bl2 && !pattern.matches(nodeInfo3, controller)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberAny(Instruction instruction, NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller, boolean bl) throws XPathException {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl2;
        NodeInfo nodeInfo2 = null;
        int n = 0;
        boolean bl3 = bl2 = !bl && pattern != null;
        if (bl2 && (objectArray2 = (Object[])controller.getUserData(instruction, "xsl:number")) != null) {
            nodeInfo2 = (NodeInfo)objectArray2[0];
            n = (Integer)objectArray2[1];
        }
        int n2 = 0;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeKindTest(nodeInfo.getItemType()) : new NameTest(nodeInfo);
            n2 = 1;
        } else if (pattern.matches(nodeInfo, controller)) {
            n2 = 1;
        }
        NodeTest nodeTest = pattern2 == null ? pattern.getNodeTest() : (pattern2.getItemType() == 1 && pattern.getItemType() == 1 ? new NodeKindTest(1) : AnyNodeTest.getInstance());
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)13, nodeTest);
        while (axisIterator.hasNext()) {
            objectArray = (Object[])axisIterator.next();
            if (pattern2 != null && pattern2.matches((NodeInfo)objectArray, controller)) {
                return n2;
            }
            if (!pattern.matches((NodeInfo)objectArray, controller)) continue;
            if (n2 == 1 && nodeInfo2 != null && objectArray.isSameNode(nodeInfo2)) {
                n2 = n + 1;
                break;
            }
            ++n2;
        }
        if (bl2) {
            objectArray = new Object[]{nodeInfo, new Integer(n2)};
            controller.setUserData(instruction, "xsl:number", (Object)objectArray);
        }
        return n2;
    }

    public static List getNumberMulti(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Controller controller) throws XPathException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeKindTest(nodeInfo.getItemType()) : new NameTest(nodeInfo);
        }
        NodeInfo nodeInfo2 = nodeInfo;
        do {
            if (!pattern.matches(nodeInfo2, controller)) continue;
            int n = Navigator.getNumberSingle(nodeInfo2, pattern, null, controller);
            arrayList.add(0, new Long(n));
        } while ((nodeInfo2 = nodeInfo2.getParent()) != null && (pattern2 == null || !pattern2.matches(nodeInfo2, controller)));
        return arrayList;
    }

    public static void copy(NodeInfo nodeInfo, Receiver receiver, NamePool namePool, int n, boolean bl) throws TransformerException {
        switch (nodeInfo.getItemType()) {
            case 9: {
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while (axisIterator.hasNext()) {
                    ((NodeInfo)axisIterator.next()).copy(receiver, n, bl);
                }
                return;
            }
            case 1: {
                receiver.startElement(nodeInfo.getNameCode(), 0, 0);
                if (n != 0) {
                    nodeInfo.outputNamespaceNodes(receiver, true);
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2, new AnyNodeTest());
                while (axisIterator.hasNext()) {
                    ((NodeInfo)axisIterator.next()).copy(receiver, n, bl);
                }
                AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)3, new AnyNodeTest());
                while (axisIterator2.hasNext()) {
                    ((NodeInfo)axisIterator2.next()).copy(receiver, n, bl);
                }
                receiver.endElement();
                return;
            }
            case 2: {
                receiver.attribute(nodeInfo.getNameCode(), 0, nodeInfo.getStringValue(), 0);
                return;
            }
            case 3: {
                receiver.characters(nodeInfo.getStringValue(), 0);
                return;
            }
            case 8: {
                receiver.comment(nodeInfo.getStringValue(), 0);
                return;
            }
            case 7: {
                receiver.processingInstruction(nodeInfo.getLocalName(), nodeInfo.getStringValue(), 0);
                return;
            }
            case 13: {
                receiver.namespace(namePool.allocateNamespaceCode(nodeInfo.getLocalName(), nodeInfo.getStringValue()), 0);
                return;
            }
        }
    }
}

