/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;

public abstract class Name {
    public static final boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return XMLChar.isValidNCName(string);
        }
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        if (!XMLChar.isValidNCName(string.substring(0, n))) {
            return false;
        }
        return XMLChar.isValidNCName(string.substring(n + 1));
    }

    public static final String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static final String[] getQNameParts(String string) throws QNameException {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        if (n < 0) {
            stringArray[0] = "";
            stringArray[1] = string;
            if (!XMLChar.isValidNCName(string)) {
                throw new QNameException("Invalid QName '" + string + "'");
            }
        } else {
            if (n == 0) {
                throw new QNameException("QName cannot start with colon: '" + string + "'");
            }
            if (n == string.length() - 1) {
                throw new QNameException("QName cannot end with colon: '" + string + "'");
            }
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
            if (!XMLChar.isValidNCName(stringArray[0])) {
                throw new QNameException("Invalid QName prefix '" + stringArray[0] + "'");
            }
            if (!XMLChar.isValidNCName(stringArray[1])) {
                throw new QNameException("Invalid QName local part '" + stringArray[1] + "'");
            }
        }
        return stringArray;
    }
}

