/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return false;
    }

    public Document newDocument() {
        return new TinyDocumentImpl();
    }

    public Document parse(InputSource inputSource) throws SAXException {
        try {
            TinyBuilder tinyBuilder = new TinyBuilder();
            NamePool namePool = NamePool.getDefaultNamePool();
            tinyBuilder.setNamePool(namePool);
            SAXSource sAXSource = new SAXSource(inputSource);
            sAXSource.setSystemId(inputSource.getSystemId());
            new Sender(new Configuration()).send(sAXSource, tinyBuilder, namePool, false);
            TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)tinyBuilder.getCurrentDocument();
            namePool.allocateDocumentNumber(tinyDocumentImpl);
            return tinyDocumentImpl;
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public DOMImplementation getDOMImplementation() {
        return new TinyDocumentImpl().getImplementation();
    }
}

